import java.net.*;
import java.io.*;

/** Uproszczony sposb tworzenia obiektw klas
 *  BufferedReader oraz PrintWriter skojarzonych z 
 *  obiektem klasy Socket.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 */

public class SocketUtil {
  /** Buffreader ma odczytywa nadsyane dane. */
  
  public static BufferedReader getReader(Socket s)
      throws IOException {
    return(new BufferedReader(
	     new InputStreamReader(s.getInputStream())));
  }

  /** PrintWriter ma wysya informacje wyjciowe.
   *  W tym obiekcie klasy PrintWriter bufor wyjciowy
   *  bdzie automatycznie oprniany po wywoaniu metody 
   *  println.
   */
  
  public static PrintWriter getWriter(Socket s)
      throws IOException {
    // drugi argument o wartoci true oznacza, e naley
    // automatycznie oprnia bufor wyjciowy
    return(new PrintWriter(s.getOutputStream(), true));
  }
}
