import java.net.*;  
import java.io.*;

/** Klasa wyjciowa do tworzenia klientw sieciowych (programw
 *  korzystajcych z komunikacji sieciowej). Bdziesz 
 *  musia przesoni metod handleConnection, jednak 
 *  w wielu przypadkach metoda connect moe pozosta 
 *  w niezmienionej postaci. Klasa wykorzystuje klas
 *  SocketUtil aby uproci proces tworzenia obiektw klas
 *  PrintWriter oraz BufferedReader.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 */

public class NetworkClient {
  protected String host;
  protected int port;

  /** Zarejestruj host i port. Poczenie sieciowe 
   *  nie zostanie jednak nawizane a do momentu 
   *  wywoania metody connect.
   */
  
  public NetworkClient(String host, int port) {
    this.host = host;
    this.port = port;
  }

  /** Nawizuje poczenie, a nastpnie przekazuje gniazdo
   *  (socket) do metody handleConnection
   */
  
  public void connect() {
    try {
      Socket client = new Socket(host, port);
      handleConnection(client);
    } catch(UnknownHostException uhe) {
      System.out.println("Nieznany host: " + host);
      uhe.printStackTrace();
    } catch(IOException ioe) {
      System.out.println("IOException: " + ioe);
      ioe.printStackTrace();
    }
  }

  /** T metod bdziesz musia przesoni piszc
   *  wasny program korzystajcy z pocze sieciowych.
   *  Domylna wersja metody przesya na serwer  
   *  pojedynczy wiersz tekstu *Ogolny klient sieciowy*,
   *  odczytuje jeden wiersz wynikw, wywietla go 
   *  i koczy dziaanie.
   */
  
  protected void handleConnection(Socket client)
      throws IOException {
    PrintWriter out =
      SocketUtil.getWriter(client);
    BufferedReader in =
      SocketUtil.getReader(client);
    out.println("Ogolny klient sieciowy");
    System.out.println
      ("Oglny klient sieciowy:\n" +
       "Nawizano poczenie z " + host +
       " i odebrano odpowied o postaci: '" + in.readLine() + "'.");
    client.close();
  }

  /** Nazwa komputera (hosta) dla serwera z ktrym nawizujesz 
   *  poczenie.
   */
  
  public String getHost() {
    return(host);
  }

  /** Numer portu na ktrym zostanie nawizane poczenie. */
  
  public int getPort() {
    return(port);
  }
}
