import java.net.*;
import java.io.*;

/** Klasa bazowa uywana przy tworzeniu serwerw sieciowych.
 *  Naley przesoni metod handleConnection, jednak w wielu
 *  przypadkach metoda listen moe pozosta w niezmienionej
 *  postaci. Klasa NetworkServer uywa klasy SocketUtil
 *  aby uproci sobie zadanie tworzenia egzemplarzy obiektw
 *  PrintWriter oraz BufferedReader.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class NetworkServer {
  private int port, maxConnections;

  /** Tworzy serwer pracujcy na podanym porcie. Serwer bdzie
   *  przyjmowa poczenia, przekazujc kade z nich do 
   *  metody handleConnection, a do momentu otrzymania 
   *  jawnego polecenia przerwania pracy (na przykad: 
   *  System.exit) lub przekroczenia iloci dopuszczalnych
   *  pocze. Jeli chcesz, aby serwer dziaa w nieskoczono
   *  to jako maxConnections podaj warto 0.
   */
  
  public NetworkServer(int port, int maxConnections) {
    setPort(port);
    setMaxConnections(maxConnections);
  }

  /** Monitoruje port na ktry bd przesyane proby
   *  o poczenie z serwerem. Za kadym razem gdy 
   *  poczenie zostanie nawizane, uzyskany egzemplarz
   *  obiektu klasy Socket jest przekazywany do metody
   *  handleConnection.
   */
  
  public void listen() {
    int i=0;
    try {
      ServerSocket listener = new ServerSocket(port);
      Socket server;
      while((i++ < maxConnections) || (maxConnections == 0)) {
        server = listener.accept();
        handleConnection(server);
      }
    } catch (IOException ioe) {
      System.out.println("IOException: " + ioe);
      ioe.printStackTrace();
    }
  }

  /** To jest metoda definiujca sposb dziaania 
   *  serwera, gdy okrela ona co si dzieje z wynikowym
   *  gniazdem (egzemplarzem obiektu klasy Socket).
   *  <B>W serwerach, ktre bdziesz pisa, powiniene
   *  przesoni t metod</B>.
   *  <P>
   *  Ta oglna wersja metody okrela komputer, ktry
   *  nadesa danie, wywietla pierwszy wiersz dania
   *  nadesany przez klienta i generuje pierwszy wiersz
   *  odpowiedzi HTTP.
   */

  protected void handleConnection(Socket server)
      throws IOException{
    BufferedReader in = SocketUtil.getReader(server);
    PrintWriter out = SocketUtil.getWriter(server);
    System.out.println
      ("Oglny serwer sieciowy: odebrano poczenie z " +
       server.getInetAddress().getHostName() + "\n" +
       "pierwszy wiersz dania '" + in.readLine() + "'");
    out.println("Oglny serwer sieciowy");
    server.close();
  }

  /** Zwraca maksymaln ilo pocze, jaka zostanie 
   *  obsuona zanim serwer przestanie dziaa.
   *  Warto 0 oznacza, e serwer powinien dziaa a
   *  do momentu gdy jawnie zostanie zamknity.
   */

  public int getMaxConnections() {
    return(maxConnections);
  }

  /** Okrela maksymaln ilo pocze. Warto 0 oznacza
   *  e serwer powinien dziaa w nieskoczono (a do
   *  momentu gdy zostanie jawnie zamknity).
   */

  public void setMaxConnections(int maxConnections) {
    this.maxConnections = maxConnections;
  }

  /** Zwraca numer portu, na ktrym dziaa serwer. */

  public int getPort() {
    return(port);
  }

  /** Okrela numer portu. <B>Port mona okreli wycznie 
   *  przed wywoaniem metody "connect"</B>. Zazwyczaj port
   *  jest okrelany w konstruktorze.
   */

  protected void setPort(int port) {
    this.port = port;
  }
}
