import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

/** Aplet odczytuje tablice acuchw znakw zapisane w
 *  obiektach QueryCollection i wywietla je w obszarze 
 *  tekstowym wyposaonym w pionowy pasek przewijania.
 *  QueryCollection pobiera acuchy znakw za porednictwem
 *  strumienia przesyajcego serializowane obiekty,
 *  podczonego do serwletu QueryGenerator.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class ShowQueries extends Applet
                         implements ActionListener, Runnable {
  private TextArea queryArea;
  private Button startButton, stopButton, clearButton;
  private QueryCollection currentQueries;
  private QueryCollection nextQueries;
  private boolean isRunning = false;
  private String address =
    "/servlet/coreservlets.QueryGenerator";
  private URL currentPage;
  
  public void init() {
    setBackground(Color.white);
    setLayout(new BorderLayout());
    queryArea = new TextArea();
    queryArea.setFont(new Font("Serif", Font.PLAIN, 14));
    add(queryArea, BorderLayout.CENTER);
    Panel buttonPanel = new Panel();
    Font buttonFont = new Font("SansSerif", Font.BOLD, 16);
    startButton = new Button("Start");
    startButton.setFont(buttonFont);
    startButton.addActionListener(this);
    buttonPanel.add(startButton);
    stopButton = new Button("Stop");
    stopButton.setFont(buttonFont);
    stopButton.addActionListener(this);
    buttonPanel.add(stopButton);
    clearButton = new Button("Usu zapytania");
    clearButton.setFont(buttonFont);
    clearButton.addActionListener(this);
    buttonPanel.add(clearButton);
    add(buttonPanel, BorderLayout.SOUTH);
    currentPage = getCodeBase();
    // Zadaj zbioru przykadowych zapyta. Zostan
    // one pobrane przy wykorzystaniu wtku dziaajcego w tle,
    // a przed prb pobrania acuchw znakw aplet sprawdzi 
    // czy pobieranie danych zostao zakoczone.
    currentQueries = new QueryCollection(address, currentPage);
    nextQueries = new QueryCollection(address, currentPage);
  }

  /** Jeli klikne przycisk "Start", system
   *  uruchomi wtek dziaajcy w tle i wywietlajcy zapytania
   *  w obszarze tekstowym. Kliknicie przycisku "Stop"
   *  zatrzymuje ten proces, a kliknicie przycisku 
   *  "Usu zapytania" powoduje usunicie caej zawartoci 
   *  obszaru tekstowego.
   */
 
  public void actionPerformed(ActionEvent event) {
    if (event.getSource() == startButton) {
      if (!isRunning) {
        Thread queryDisplayer = new Thread(this);
        isRunning = true;
        queryArea.setText("");
        queryDisplayer.start();
        showStatus("Wtek prezentujcy zapytania uruchomiony...");
      } else {
        showStatus("Wtek prezentujcy zapytania ju dziaa...");
      }
    } else if (event.getSource() == stopButton) {
      isRunning = false;
      showStatus("Wtek prezentujcy zapytania zosta zatrzymany...");
    } else if (event.getSource() == clearButton) {
      queryArea.setText("");
    }
  }

  /** Wtek dziaajcy w tle pobiera obiekt currentQueries
   *  i co p sekundy wywietla u dou obszaru tekstowego 
   *  jedno z zapyta zapisanych w tym obiekcie. Po wywietleniu
   *  wszystkich zapyta, wtek kopiuje do obiektu 
   *  currentQueries zawarto obiektu nextQueries, przesya
   *  na serwer nowe danie w celu okrelenia nowej wartoci
   *  obiektu nextQueries i powtarza cay proces.
   */

  public void run() {
    while(isRunning) {
      showQueries(currentQueries);
      currentQueries = nextQueries;
      nextQueries = new QueryCollection(address, currentPage);
    }
  }

  private void showQueries(QueryCollection queryEntry) {
    // Jesli danie zostao przesane na serwer, lecz 
    // wyniki jeszcze nie zostay otrzymane, to sprawdzaj
    // czy s dostpne co sekund. Nie powinno si to
    // zdarza czsto, jednak moe si zdarzy w przypadku
    // stosowania wolnych pocze sieciowych bd w 
    // w przypadku przecienia serwera.
    while(!queryEntry.isDone()) {
      showStatus("Oczekiwanie na dane z serwera...");
      pause(1);
    }
    showStatus("Pobieranie danych z serwera...");
    String[] queries = queryEntry.getQueries();
    String linefeed = "\n";
    // umieszczaj zapytania w obszarze tekstowym co p sekundy.
    for(int i=0; i<queries.length; i++) {
      if (!isRunning) {
        return;
      }
      queryArea.append(queries[i]);
      queryArea.append(linefeed);
      pause(0.5);
    }
  }

  public void pause(double seconds) {
    try {
      Thread.sleep((long)(seconds*1000));
    } catch(InterruptedException ie) {}
  }
}
