import java.net.*;
import java.io.*;

/** Gdy ta klasa zostanie stworzona, zwraca warto od razu,
 *  jednak warto ta zwraca false dla isDone
 *  oraz null dla getQueries. W midzyczasie, uruchamiany jest
 *  wtek (Thread) dajcy pobrania z serwera tablicy acuchw
 *  znakw zawierajcej zapytania i odczytujcy je w jednym korku
 *  dziki uyciu strumienia ObjectInputStream. 
 *  Po odczytaniu wszystkich wynikw, s one umieszczane w 
 *  miejscu zwrconym przez getQueries, a fladze isDone 
 *  przypisywana jest warto true.
 *  Klasa uywana przez aplet ShowQueries. 
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class QueryCollection implements Runnable {
  private String[] queries;
  private String[] tempQueries;
  private boolean isDone = false;
  private URL dataURL;

  public QueryCollection(String urlSuffix, URL currentPage) {
    try {
      // Trzeba poda wycznie kocwk adresu URL,
      // gdy jego pozostaa cz jest okrelana na
      // podstawie biecej strony.
      String protocol = currentPage.getProtocol();
      String host = currentPage.getHost();
      int port = currentPage.getPort();
      dataURL = new URL(protocol, host, port, urlSuffix);
      Thread queryRetriever = new Thread(this);
      queryRetriever.start();
    } catch(MalformedURLException mfe) {
      isDone = true;
    }
  }

  public void run() {
    try {
      tempQueries = retrieveQueries();
      queries = tempQueries;
    } catch(IOException ioe) {
      tempQueries = null;
      queries = null;
    }
    isDone = true;
  }

  public String[] getQueries() {
    return(queries);
  }

  public boolean isDone() {
    return(isDone);
  }

  private String[] retrieveQueries() throws IOException {
    URLConnection connection = dataURL.openConnection();
    // Upewnij si, e przegldarka nie bdzie przechowywa
    // tego dania w pamici podrcznej. To wane, gdy
    // chcemy za kadym razem pobiera rne zapytania.
    connection.setUseCaches(false);
    // Uywam strumienia ObjectInputStream dziki czemu,
    // za jednym zamachem mona odczyta ca tablic
    // acuchw znakw.
    ObjectInputStream in =
      new ObjectInputStream(connection.getInputStream());
    try {
      // Metoda readObject zwraca warto typu Object,
      // a zatem konieczne jest przeprowadzenie odpowiedniego
      // rzutowania typw.
      String[] queryStrings = (String[])in.readObject();
      return(queryStrings);
    } catch(ClassNotFoundException cnfe) {
      return(null);
    }
  }
}
