import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;

/** Aplet odczytujcy wartoci parametrw firstName,
 *  lastName oraz emailAddress i przesyajcy je
 *  na serwer metod POST (pod podany adres i przy 
 *  uyciu portu o okrelonym numerze.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class SendPost extends Applet
                      implements ActionListener {
  private LabeledTextField firstNameField, lastNameField,
                           emailAddressField, hostField,
                           portField, uriField;
  private Button sendButton;
  private TextArea resultsArea;
  URL currentPage;
  
  public void init() {
    setBackground(Color.white);
    setLayout(new BorderLayout());
    Panel inputPanel = new Panel();
    inputPanel.setLayout(new GridLayout(9, 1));
    inputPanel.setFont(new Font("Serif", Font.BOLD, 14));
    firstNameField =
      new LabeledTextField("Imi:", 15);
    inputPanel.add(firstNameField);
    lastNameField =
      new LabeledTextField("Nazwisko:", 15);
    inputPanel.add(lastNameField);
    emailAddressField =
      new LabeledTextField("Adres email:", 25);
    inputPanel.add(emailAddressField);
    Canvas separator1 = new Canvas();
    inputPanel.add(separator1);
    hostField =
      new LabeledTextField("Host:", 15);
    
    // Aplety pobierane przez Internet mog si
    // czy tylko z serwerem, z ktrego zostay pobrane.
    hostField.getTextField().setEditable(false);
    
    currentPage = getCodeBase();
    // metoda getHost zwraca pusty acuch znakw
    // jeli aplet zosta pobrany z lokalnego dysku.
    String host = currentPage.getHost();
    String resultsMessage = "Tutaj zostan wywietlone wyniki...";
    if (host.length() == 0) {
      resultsMessage = "Bd: musisz pobra ten aplet z \n" +
                       "prawdziwego serwera WWW za porednictwem HTTP,\n" +
                       "a nie jako plik z lokalnego dysku.\n" +
                       "Nawet jeli serwer dziaa na Twoim \n" +
                       "lokalnym komputerze.";
      setEnabled(false);
    }
    hostField.getTextField().setText(host);
    inputPanel.add(hostField);
    portField =
      new LabeledTextField("Port (-1 oznacza domylny):", 4);
    String portString = String.valueOf(currentPage.getPort());
    portField.getTextField().setText(portString);
    inputPanel.add(portField);
    uriField =
      new LabeledTextField("URI:", 40);
    String defaultURI = "/servlet/coreservlets.ShowParameters";
    uriField.getTextField().setText(defaultURI);
    inputPanel.add(uriField);
    Canvas separator2 = new Canvas();
    inputPanel.add(separator2);
    sendButton = new Button("Wylij dane");
    sendButton.addActionListener(this);
    Panel buttonPanel = new Panel();
    buttonPanel.add(sendButton);
    inputPanel.add(buttonPanel);
    add(inputPanel, BorderLayout.NORTH);
    resultsArea = new TextArea();
    resultsArea.setFont(new Font("Monospaced", Font.PLAIN, 14));
    resultsArea.setText(resultsMessage);
    add(resultsArea, BorderLayout.CENTER);
  }

  public void actionPerformed(ActionEvent event) {
    try {
      String protocol = currentPage.getProtocol();
      String host = hostField.getTextField().getText();
      String portString = portField.getTextField().getText();
      int port;
      try {
        port = Integer.parseInt(portString);
      } catch(NumberFormatException nfe) {
        port = -1; // na przykad, domylnie port 80
      }
      String uri = uriField.getTextField().getText();
      URL dataURL = new URL(protocol, host, port, uri);
      URLConnection connection = dataURL.openConnection();
      
      // Upewnij si e przegldarka nie bdzie 
      // przechowywa danych w pamici podrcznej.
      connection.setUseCaches(false);
      
      // Popro przegldark o pozwolenie przesyania danych
      // na serwer.
      connection.setDoOutput(true);
      
      ByteArrayOutputStream byteStream =
        new ByteArrayOutputStream(512); // Powiksz jeli konieczne
      // Strumie zapisuje dane do buforu
      PrintWriter out = new PrintWriter(byteStream, true);
      String postData =
        "firstName=" + encodedValue(firstNameField) +
        "&lastName=" + encodedValue(lastNameField) +
        "&emailAddress=" + encodedValue(emailAddressField);
      
      // Zapisz dane do lokalnego buforu
      out.print(postData);
      out.flush(); // oprnij bufor gdy uywamy metody print
      // a nie println.

      // dania POST musz zawiera nagwek Content-Length
      String lengthString =
        String.valueOf(byteStream.size());
      connection.setRequestProperty
        ("Content-Length", lengthString);
      
      // Netscape domylnie zapisuje w nagwku 
      // Content-Type warto multipart/form-data.
      // A zatem, jeli chcesz wysya zwyczajne 
      // informacje wprowadzone przez uytkownika w 
      // formularzu, musisz samemu przypisa temu
      // nagwkowi warto 
      // application/x-www-form-urlencoded, ktra 
      // jest domylnie stosowana w przegldarce 
      // Internet Explorer. Jeli metod POST przesyasz
      // serializowane dane (posugujc si przy tym
      // strumieniem ObjectOutputStream, to zawarto
      // nagwka Content-Type nie ma znaczenia, a zatem
      // bdziesz mg pomin ten krok.
      connection.setRequestProperty
        ("Content-Type", "application/x-www-form-urlencoded");
      
      // Zapisz dane do faktycznego strumienia wyjciowego
      byteStream.writeTo(connection.getOutputStream());

      BufferedReader in =
        new BufferedReader(new InputStreamReader
                             (connection.getInputStream()));
      String line;
      String linefeed = "\n";
      resultsArea.setText("");
      while((line = in.readLine()) != null) {
        resultsArea.append(line);
        resultsArea.append(linefeed);
      }
    } catch(IOException ioe) {
      // Wywietl komunikat na konsoli Javy.
      System.out.println("IOException: " + ioe);
    }
  }
  
  // LabeledTextField to w rzeczywistoci Panel zawierajcy
  // etykiet (Label) oraz pole tekstowe (TextField).
  // Poniszy kod pobiera zawarto pola tekstowego, 
  // zapisuje j w formacie URL i zwraca.
  
  private String encodedValue(LabeledTextField field) {
    String rawValue = field.getTextField().getText();
    return(URLEncoder.encode(rawValue));
  }
    
}
