import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import coreservlets.SearchSpec;

/** Aplet odczytuje warto z pola TextField,
 *  a nastpnie uywa jej do stworzenia trzech rnych 
 *  adresw URL zawierajcych w sobie dane podane w 
 *  formularzu. Adresy te odwouj si do mechanizmw
 *  wyszukiwawczych Google, Go.com, and Lycos.
 *  Przegldarka pobiera zasoby o podanych adresach URL 
 *  i wywietla je w trzech umieszczonych obok siebie
 *  ramkach. Zwr uwag i zwyczajne formularze HTML
 *  nie s w stanie wykona takiego zadania, gdy 
 *  nie dysponuj moliwoci przesyania kilku da
 *  jednoczenie.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class SearchApplet extends Applet
                          implements ActionListener {
  private TextField queryField;
  private Button submitButton;

  public void init() {
    setFont(new Font("Serif", Font.BOLD, 18));
    add(new Label("Wyszukiwany acuch znakw:"));
    queryField = new TextField(40);
    queryField.addActionListener(this);
    add(queryField);
    submitButton = new Button("Przelij zapytanie");
    submitButton.addActionListener(this);
    add(submitButton);
  }

  /** Wylij dane gdy zostanie kliknity przycisk <B>lub</B>
   *  uytkownik nacinie klawisz Enter w polu TextField.
   */
  
  public void actionPerformed(ActionEvent event) {
    String query = URLEncoder.encode(queryField.getText());
    SearchSpec[] commonSpecs = SearchSpec.getCommonSpecs();
    // Pomi HotBot (ostatni wpis), gdy ta wyszukiwarka uywa 
    // JavaScriptu do wywietlenia wynikw w ramce najwyszego poziomu.
    // Z tego wzgldu poniej uywam wyraenia length-1 .
    for(int i=0; i<commonSpecs.length-1; i++) {
      try {
        SearchSpec spec = commonSpecs[i];
        // Klasa SearchSpec tworzy adresy URL o postaci uywanej
        // przez kilka popularnych mechanizmw wyszukiwawczych.
        URL searchURL = new URL(spec.makeURL(query, "10"));
        String frameName = "results" + i;
        getAppletContext().showDocument(searchURL, frameName);
      } catch(MalformedURLException mue) {}
    }
  }
}
