package coreservlets.tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;
import java.math.*;
import coreservlets.*;

/** Generuje liczby pierwsze o dugoci okoo 50 cyfr
 *  (50 cyfr ma dugo losowo wygenerowanej liczby,
 *  zwrcona liczba pierwsza bdzie wiksza od wygenerowanej
 *  liczy losowej.)
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class SimplePrimeTag extends TagSupport {
  protected int len = 50;
  
  public int doStartTag() {
    try {
      JspWriter out = pageContext.getOut();
      BigInteger prime = Primes.nextPrime(Primes.random(len));
      out.print(prime);
    } catch(IOException ioe) {
      System.out.println("Bd przy generowaniu liczby pierwszej: " + ioe);
    }
    return(SKIP_BODY);
  }
}
