package coreservlets.tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;
import javax.servlet.*;

/** Cz okrelajca warunek w znaczniku if.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class IfConditionTag extends BodyTagSupport {
  public int doStartTag() throws JspTagException {
    IfTag parent =
      (IfTag)findAncestorWithClass(this, IfTag.class);
    if (parent == null) {
      throw new JspTagException("Warunek nie jest umieszczony wewntrz znacznika if");
    } 
    return(EVAL_BODY_TAG);
  }

  public int doAfterBody() {
    IfTag parent =
      (IfTag)findAncestorWithClass(this, IfTag.class);
    String bodyString = getBodyContent().getString();
    if (bodyString.trim().equals("true")) {
      parent.setCondition(true);
    } else {
      parent.setCondition(false);
    }
    return(SKIP_BODY);
  }
}
