package coreservlets.tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;
import coreservlets.*;

/** Znacznik zamieniajcy znaki <, >, " oraz & na odpowiednie
 *  symbole HTML (&lt;, &gt;, &quot;, and &amp;).
 *  Po przefiltrowaniu, dowolne acuchy znakw mog zosta
 *  osadzone bd to w treci generowanej strony WWW, lub 
 *  te mona ich uy jako wartoci atrybutw znacznikw.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class FilterTag extends BodyTagSupport {
  public int doAfterBody() {
    BodyContent body = getBodyContent();
    String filteredBody =
      ServletUtilities.filter(body.getString());
    try {
      JspWriter out = body.getEnclosingWriter();
      out.print(filteredBody);
    } catch(IOException ioe) {
      System.out.println("Bd w znaczniku FilterTag: " + ioe);
    }
    // SKIP_BODY oznacza e praca zostaa zakoczona. Aby
    // jeszcze raz przetworzy i obsuy zawarto znacznika, 
    // naleao by zwrci warto EVAL_BODY_TAG.
    return(SKIP_BODY);
  }
}
