package coreservlets;

import javax.swing.*;
import java.awt.*;

/** Kilka narzdzi uatwiajcych stosowanie okien 
 *  w pakiecie Swing.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class WindowUtilities {

  /** Informuje system e naley uywa rodzimego wygldu
   *  (ang. "look and feel"), podobnie jak w wersjach wczeniejszych
   *  W pozostaych przypadkach uywany jest wygld "Metal" (Java)
   */

  public static void setNativeLookAndFeel() {
    try {
      UIManager.setLookAndFeel
        (UIManager.getSystemLookAndFeelClassName());
    } catch(Exception e) {
      System.out.println("Bd przy wyborze wygldu: " + e);
    }
  }

  public static void setJavaLookAndFeel() {
    try {
      UIManager.setLookAndFeel
        (UIManager.getCrossPlatformLookAndFeelClassName());
    } catch(Exception e) {
      System.out.println("Bd przy wyborze wygldu: " + e);
    }
  }

  public static void setMotifLookAndFeel() {
    try {
      UIManager.setLookAndFeel
        ("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
    } catch(Exception e) {
      System.out.println("Bd przy wyborze wygldu Motif: " + e);
    }
  }

  /** Uproszczony sposb wywietlania JPane lub innych
   *  obiektw Container. Wywietla okno JFrame w ktrym
   *  jako zawarto jest umieszczony podany panel.
   */

  public static JFrame openInJFrame(Container content,
                                    int width,
                                    int height,
                                    String title,
                                    Color bgColor) {
    JFrame frame = new JFrame(title);
    frame.setBackground(bgColor);
    content.setBackground(bgColor);
    frame.setSize(width, height);
    frame.setContentPane(content);
    frame.addWindowListener(new ExitListener());
    frame.setVisible(true);
    return(frame);
  }

  /** Uywa Color.white jako koloru ta. */

  public static JFrame openInJFrame(Container content,
                                    int width,
                                    int height,
                                    String title) {
    return(openInJFrame(content, width, height, title, Color.white));
  }

  /** Uywa Color.white jako koloru ta i nazwy klasy
   *  przekazanego obiektu Container jako tytuu okna.
   */

  public static JFrame openInJFrame(Container content,
                                    int width,
                                    int height) {
    return(openInJFrame(content, width, height,
                        content.getClass().getName(),
                        Color.white));
  }
}
