package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Gwny serwlet obsugujcy internetowe biuro podry.
 *  Serwlet zapisuje dane klienta w formie komponentu JavaBean
 *  a nastpnie przekazuje danie do strony rezerwacji biletw
 *  lotniczych, wypoyczania samochodu, poszukiwania hoteli 
 *  edycji konta istniejcego uytkownika lub tworzenia nowego
 *  konta.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class Travel extends HttpServlet {
  private TravelCustomer[] travelData;

  public void init() {
    travelData = TravelData.getTravelData();
  }

  /** Poniewa przesyamy haso mona uy wycznie metody POST.
   *  Jednak uycie tej metody oznacza, e dania nie mog 
   *  by przesyane do statycznych dokumentw HTML (wynika to
   *  z faktu, e podczas przekazywania dania uywany jest 
   *  ten sam typ dania, a statyczne strony WWW nie s w stanie
   *  obsugiwa da POST). Rozwizanie tego problemu jest
   *  proste: Niech statyczne strony HTML bd stronami JSP
   *  zawierajcymi wycznie kod HTML. Tak jest w przypadku 
   *  dokumentu accounts.jsp. Pozostae pliki JSP faktycznie
   *  musz by generowane dynamicznie, gdy korzystaj z 
   *  danych o uytkowniku.
   */
  
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; encoding=ISO-8859-2");
    String emailAddress = request.getParameter("emailAddress");
    String password = request.getParameter("password");
    TravelCustomer customer =
      TravelCustomer.findCustomer(emailAddress, travelData);
    if ((customer == null) || (password == null) ||
        (!password.equals(customer.getPassword()))) {
      gotoPage("/travel/accounts.jsp", request, response);
    }
    // Metody uywajce poniszych parametrw bd 
    // same sprawdzay czy informacje s poprawne 
    // i czy w ogle zostay podane.
    customer.setStartDate(request.getParameter("startDate"));
    customer.setEndDate(request.getParameter("endDate"));
    customer.setOrigin(request.getParameter("origin"));
    customer.setDestination(request.getParameter("destination"));
    HttpSession session = request.getSession(true);
    session.putValue("customer", customer);
    if (request.getParameter("flights") != null) {
      gotoPage("/travel/BookFlights.jsp",
               request, response);
    } else if (request.getParameter("cars") != null) {
      gotoPage("/travel/RentCars.jsp",
               request, response);
    } else if (request.getParameter("hotels") != null) {
      gotoPage("/travel/FindHotels.jsp",
               request, response);
    } else if (request.getParameter("cars") != null) {
      gotoPage("/travel/EditAccounts.jsp",
               request, response);
    } else {
      gotoPage("/travel/IllegalRequest.jsp",
               request, response);
    }
  }
  
  private void gotoPage(String address,
                        HttpServletRequest request,
                        HttpServletResponse response)
      throws ServletException, IOException {
    RequestDispatcher dispatcher =
      getServletContext().getRequestDispatcher(address);
    dispatcher.forward(request, response);
  }
}
