package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

/** Servlet obsugujcy przegldanie i przechowywanie 
 *  yciorysw przesyanych przez osoby poszukujce pracy.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class SubmitResume extends HttpServlet {
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    if (request.getParameter("previewButton") != null) {
      showPreview(request, out);
    } else {
      storeResume(request);
      showConfirmation(request, out);
    }
  }

  /* Wywietla podgld nadesanego yciorysu. Pobiera
   * informacje o czcionce i na jego podstawie tworzy 
   * arkusz stylw; nastpnie pobiera informacje
   * yciorysu i prezentuje je na stronie. Wygld 
   * prezentowanych informacji okrela arkusz stylw.
   */ 
  
  private void showPreview(HttpServletRequest request,
                          PrintWriter out) {
    String headingFont = request.getParameter("headingFont");
    headingFont = replaceIfMissingOrDefault(headingFont, "");
    int headingSize =
      getSize(request.getParameter("headingSize"), 32);
    String bodyFont = request.getParameter("bodyFont");
    bodyFont = replaceIfMissingOrDefault(bodyFont, "");
    int bodySize =
      getSize(request.getParameter("bodySize"), 18);
    String fgColor = request.getParameter("fgColor");
    fgColor = replaceIfMissing(fgColor, "BLACK");
    String bgColor = request.getParameter("bgColor");
    bgColor = replaceIfMissing(bgColor, "WHITE");
    String name = request.getParameter("name");
    name = replaceIfMissing(name, "Lou Zer");
    String title = request.getParameter("title");
    title = replaceIfMissing(title, "ob.");
    String email = request.getParameter("email");
    email =
      replaceIfMissing(email, "contact@superfucha.com");
    String languages = request.getParameter("languages");
    languages = replaceIfMissing(languages, "<I>Brak</I>");
    String languageList = makeList(languages);
    String skills = request.getParameter("skills");
    skills = replaceIfMissing(skills, "Niewiele.");
    out.println
      (ServletUtilities.DOCTYPE + "\n" +
       "<HTML>\n" +
       "<HEAD>\n" +
       "<TITLE>yciorys - " + name + "</TITLE>\n" +
       makeStyleSheet(headingFont, headingSize,
                      bodyFont, bodySize,
                      fgColor, bgColor) + "\n" +
       "</HEAD>\n" +
       "<BODY>\n" + 
       "<CENTER>\n"+
       "<SPAN CLASS=\"HEADING1\">" + name + "</SPAN><BR>\n" +
       "<SPAN CLASS=\"HEADING2\">" + title + "<BR>\n" +
       "<A HREF=\"mailto:" + email + "\">" + email +
           "</A></SPAN>\n" +
       "</CENTER><BR><BR>\n" +
       "<SPAN CLASS=\"HEADING3\">Jzyki programowania" +
       "</SPAN>\n" +
       makeList(languages) + "<BR><BR>\n" +
       "<SPAN CLASS=\"HEADING3\">Umiejtnoci i dowiadczenia" +
       "</SPAN><BR><BR>\n" +
       skills + "\n" +
       "</BODY></HTML>");
  }

  /* Metoda tworzy kaskadowy arkusz stylw zawierajcy informacje
   * o trzech poziomach nagwkw oraz kolorze ta i tekstu.
   * W przypadku Internet Explorera kolor poczenia mailto 
   * jest zmieniany po umieszczeniu na nim wskanika myszy.
   */
  
  private String makeStyleSheet(String headingFont,
                                int heading1Size,
                                String bodyFont,
                                int bodySize,
                                String fgColor,
                                String bgColor) {
    int heading2Size = heading1Size*7/10;
    int heading3Size = heading1Size*6/10;
    String styleSheet =
      "<STYLE TYPE=\"text/css\">\n" +
      "<!--\n" +
      ".HEADING1 { font-size: " + heading1Size + "px;\n" +
      "            font-weight: bold;\n" +
      "            font-family: " + headingFont +
                     "Arial, Helvetica, sans-serif;\n" +
      "}\n" +
      ".HEADING2 { font-size: " + heading2Size + "px;\n" +
      "            font-weight: bold;\n" +
      "            font-family: " + headingFont +
                     "Arial, Helvetica, sans-serif;\n" +
      "}\n" +
      ".HEADING3 { font-size: " + heading3Size + "px;\n" +
      "            font-weight: bold;\n" +
      "            font-family: " + headingFont +
                     "Arial, Helvetica, sans-serif;\n" +
      "}\n" +
      "BODY { color: " + fgColor + ";\n" +
      "       background-color: " + bgColor + ";\n" +
      "       font-size: " + bodySize + "px;\n" +
      "       font-family: " + bodyFont +
                    "Times New Roman, Times, serif;\n" +
      "}\n" +
      "A:hover { color: red; }\n" +
      "-->\n" +
      "</STYLE>";
    return(styleSheet);
  }

  /* Zastpuje nieistnijce (null) acuchy znakw 
   * (gdy parametr nie zosta podany) oraz puste acuchy
   * znakw (w polu tekstowym niczego nie wpisano), 
   * podan wartoci domyln. W przeciwnym razie, zwraca
   * oryginalny acuch znakw.
   */
  
  private String replaceIfMissing(String orig,
                                  String replacement) {
    if ((orig == null) || (orig.length() == 0)) {
      return(replacement);
    } else {
      return(orig);
    }
  }

  /* Zastpuje nieistniejce (null) acuchy znakw, puste
   * acuchy oraz acuch o wartoci "default", podanym
   * zamiennikiem. W przeciwnym razie zwraca oryginalny
   * acuch znakw.
   */
  
  private String replaceIfMissingOrDefault(String orig,
                                           String replacement) {
    if ((orig == null) ||
        (orig.length() == 0) ||
        (orig.equals("default"))) {
      return(replacement);
    } else {
      return(orig + ", ");
    }
  }

  /* Pobiera warto cakowit zapisan w formie acucha
   * znakw i zwraca j w formie liczby cakowitej. Jeli
   * acuch znakw wynosi null lub zostaa zapisana w 
   * niewaciwym formacie, zwracana jest warto domylna.
   */
    
  private int getSize(String sizeString, int defaultSize) {
    try {
      return(Integer.parseInt(sizeString));
    } catch(NumberFormatException nfe) {
      return(defaultSize);
    }
  }

  /* acuch wejciowy "Java,C++,Lisp", "Java C++ Lisp" lub
   * "Java, C++, Lisp", powoduje wygenerowanie kodu HTML:
   * "<UL>
   *   <LI>Java
   *   <LI>C++
   *   <LI>Lisp
   *  </UL>"
   */

  private String makeList(String listItems) {
    StringTokenizer tokenizer =
      new StringTokenizer(listItems, ", ");
    String list = "<UL>\n";
    while(tokenizer.hasMoreTokens()) {
      list = list + "  <LI>" + tokenizer.nextToken() + "\n";
    }
    list = list + "</UL>";
    return(list);
  }

  /* Wywietla stron potwierdzenia gdy zostanie 
   * kliknity przycisk "Przelij".
   */
  
  private void showConfirmation(HttpServletRequest request,
                                PrintWriter out) {
    String title = "yciorys przyjty.";
    out.println(ServletUtilities.headWithTitle(title) +
                "<BODY>\n" +
                "<H1>" + title + "</H1>\n" +
                "Twj yciorys powinien si pojawi na WWW\n" +
                "w cigu 24 godzin. Jeli si nie pojawi, \n" +
                "to sprbuj go przesa ponownie podajc inny\n" +
                "adres poczty elektronicznej.\n" + 
                "</BODY></HTML>");
  }

  /* Dlaczego nie naley przesya swojego adresu poczty
   * elektronicznej witrynom ktrym nie wiadomo czy mona 
   * zaufa.
   */
  
  private void storeResume(HttpServletRequest request) {
    String email = request.getParameter("email");
    putInSpamList(email);
  }
  
  private void putInSpamList(String emailAddress) {
    // Na wszelki wypadek usunem ten kod.
  }
}
