package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.*;
import java.util.*;

/** Prosty przykad ledzenia sesji. Bardziej 
 *  zaawansowanym przykadem jest implementacja koszykw
 *  ShoppingCart.java.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class ShowSession extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    String title = "Przykad ledzenia sesji";
    HttpSession session = request.getSession(true);
    String heading;
    /* W mechanizmach obsugi servletw zgodnych ze specyfikacj
     * Java Servlet 2.2 zamiast metody getValue naley uywa
     * metody getAttribute.
     */
    Integer accessCount =
      (Integer)session.getValue("accessCount");
    if (accessCount == null) {
      accessCount = new Integer(0);
      heading = "Witamy, nowy kliencie";
    } else {
      heading = "Witamy ponownie";
      accessCount = new Integer(accessCount.intValue() + 1);
    }
    /* W mechanizmach obsugi servletw zgodnych ze specyfikacj
     * Java Servlet 2.2 zamiast metody putValue naley uywa
     * metody setAttribute.
     */
    session.putValue("accessCount", accessCount); 
      
    out.println(ServletUtilities.headWithTitle(title) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=\"CENTER\">" + heading + "</H1>\n" +
                "<H2>Informacje o Twojej sesji:</H2>\n" +
                "<TABLE BORDER=1 ALIGN=\"CENTER\">\n" +
                "<TR BGCOLOR=\"#FFAD00\">\n" +
                "  <TH>Typ<TH>Warto\n" +
                "<TR>\n" +
                "  <TD>ID\n" +
                "  <TD>" + session.getId() + "\n" +
                "<TR>\n" +
                "  <TD>Czas utworzenia\n" +
                "  <TD>" +
                new Date(session.getCreationTime()) + "\n" +
                "<TR>\n" +
                "  <TD>Czas ostatniego dostpu\n" +
                "  <TD>" +
                new Date(session.getLastAccessedTime()) + "\n" +
                "<TR>\n" +
                "  <TD>Ilo odwiedzin\n" +
                "  <TD>" + accessCount + "\n" +
                "</TABLE>\n" +
                "</BODY></HTML>");

  }

  /** dania GET i POST maj by obsugiwane jednakowo. */
  
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}
