package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Przykad zastosowania metody include interfejsu
 *  RequestDispatcher. Na podstawie podanego URI 
 *  odnoszcego si do zasobu na tym samym serwerze co
 *  serwlet, serwlet wywietla nieprzetworzone dane 
 *  zwrcone przez wskazany zasb.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class ShowPage extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html");
    PrintWriter out = response.getWriter();
    String url = request.getParameter("url");
    out.println(ServletUtilities.headWithTitle(url) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=CENTER>" + url + "</H1>\n" +
                "<FORM><CENTER>\n" +
                "<TEXTAREA ROWS=30 COLS=70>");
    if ((url == null) || (url.length() == 0)) {
      out.println("Nie podano adresu.");
    } else {
      // Doczanie dziaa tylko w specyfikacji Java Servlet 2.2
      String data = request.getParameter("data");
      if ((data != null) && (data.length() > 0)) {
        url = url + "?" + data;
      }
      RequestDispatcher dispatcher =
        getServletContext().getRequestDispatcher(url);
      dispatcher.include(request, response);
    }
    out.println("</TEXTAREA>\n" +
                "</CENTER></FORM>\n" +
                "</BODY></HTML>");
  }

  /** dania GET and POST obsugiwane tak samo. */

  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}
