package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Example using servlet initialization. Here, the message
/** Przykad wykorzystania inicjalizacji servletu. W tym przypadku
 *  wywietlany komunikat oraz liczba okrelajca ilo jego 
 *  powtrze pobierana jest z parametrw inicjalizacyjnych.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 */

public class ShowMessage extends HttpServlet {
  private String message;
  private String defaultMessage = "Brak komunikatu.";
  private int repeats = 1;
  
  public void init(ServletConfig config)
      throws ServletException {
    // Zawsze wywouj metod super.init
    super.init(config);
    message = config.getInitParameter("message");
    if (message == null) {
      message = defaultMessage;
    }
    try {
      String repeatString = config.getInitParameter("repeats");
      repeats = Integer.parseInt(repeatString);
    } catch(NumberFormatException nfe) {
      // Wyjtek NumberFormatException obsuguje przypadki 
      // gdy parametr repeatString jest rwny null *i* gdy jego
      // warto zostaa zapisana w niewaciwym formacie.
      // W oby tych przypadkach w razie przechwycenia wyjtku
      // nie naley niczego robi, gdy poprzednia warto 
      // parametru repeatString (1) wci bdzie uywana. Wynika 
      // to z faktu i metoda Integer.parseInt zgasza wyjtek 
      // *przed* przypisaniem wartoci do zmiennej.
    }
  }

    public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
        throws ServletException, IOException {
      response.setContentType("text/html; encoding=ISO-8859-2");
      PrintWriter out = response.getWriter();
      String title = "Serwlet ShowMessage";
      out.println(ServletUtilities.headWithTitle(title) +
                  "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                  "<H1 ALIGN=CENTER>" + title + "</H1>");
      for(int i=0; i<repeats; i++) {
        out.println(message + "<BR>");
      }
      out.println("</BODY></HTML>");
    }
}
