package coreservlets;

import javax.servlet.*;
import javax.servlet.http.*;

/** Narzdzia pomocnicze. Zauwa, e wikszo z nich to 
 *  metody statyczne.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class ServletUtilities {
  public static final String DOCTYPE =
    "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
    "Transitional//EN\">";

  public static String headWithTitle(String title) {
    return(DOCTYPE + "\n" +
           "<HTML>\n" +
           "<HEAD><TITLE>" + title + "</TITLE></HEAD>\n");
  }

  /** Odczytuje parametr o okrelonej nazwie, konwertuje jego
   *  warto do postaci liczby cakowitej i zwraca j.
   *  Zwraca okrelon warto domyln w przypadku gdy parametr
   *  nie zosta podany lub gdy jego warto nie jest poprawnie 
   *  zapisan liczb cakowit.  
  */
  
  public static int getIntParameter(HttpServletRequest request,
                                    String paramName,
                                    int defaultValue) {
    String paramString = request.getParameter(paramName);
    int paramValue;
    try {
      paramValue = Integer.parseInt(paramString);
    } catch(NumberFormatException nfe) { // null lub zy format
      paramValue = defaultValue;
    }
    return(paramValue);
  }

  /** Na podstawie tablicy Cookies, nazwy oraz domylnej wartoci,
   *  ta metoda prbuje odszuka warto cookie o podanej nazwie.
   *  Jeli takie cookie nie zostanie odnalezione, zwracana jest
   *  warto domylna przekazana w wywoaniu metody .
   */
  
  public static String getCookieValue(Cookie[] cookies,
                                      String cookieName,
                                      String defaultValue) {
    if (cookies != null) {
      for(int i=0; i<cookies.length; i++) {
        Cookie cookie = cookies[i];
        if (cookieName.equals(cookie.getName()))
          return(cookie.getValue());
      }
    }
    return(defaultValue);
  }

  /** Na podstawie tablicy cookies i nazwy, ta metoda prbuje 
   *  odszuka w tablicy i zwrci cookie o podanej nazwie.
   *  Jeli cookie o podanej nazwie nie zostanie odnalezione
   *  metoda zwraca null.
   */
  
  public static Cookie getCookie(Cookie[] cookies,
                                 String cookieName) {
    if (cookies != null) {
      for(int i=0; i<cookies.length; i++) {
        Cookie cookie = cookies[i];
        if (cookieName.equals(cookie.getName()))
          return(cookie);
      }
    }
    return(null);
  }

  /** Ta metoda, w przekazanym acuchu znakw zamienia wszystkie
   *  wystpienia znaku '<' kombinacj znakw '&lt;' oraz wszystkie
   *  wystpienia znaku '>' kombinacj znakw '&gt;' oraz (aby 
   *  poprawnie obsugiwa przypadku wystpienia tych znakw w wartociach
   *  atrybutw) wszystkie wystpienia cudzysoww na kombinacje znakw
   *  '&quote', wszystkie wystpienia '&' na '&amp;'. 
   *  Bez zastosowania filtrowania tego typu, aden dowolny acuch
   *  znakw nie moe by wstawiony do kodu strony WWW.
   */

  public static String filter(String input) {
    StringBuffer filtered = new StringBuffer(input.length());
    char c;
    for(int i=0; i<input.length(); i++) {
      c = input.charAt(i);
      if (c == '<') {
        filtered.append("&lt;");
      } else if (c == '>') {
        filtered.append("&gt;");
      } else if (c == '"') {
        filtered.append("&quot;");
      } else if (c == '&') {
        filtered.append("&amp;");
      } else {
        filtered.append(c);
      }
    }
    return(filtered.toString());
  }
}
