package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.*;

/** Servlet ktry pobiera zapytanie, ilo wynikw na stron
 *  oraz nazw serwisu wyszukiwawczego, a nastpnie 
 *  konstruuje zapytanie i przesya je do wybranego serwisu.
 *  Przykad ilustruje wykorzystanie kodw statusu. 
 *  Servlet przesya kod 302 (generowany przy uyciu metody
 *  sendRedirect) jeli wybrana nazwa serwisu jest znana,
 *  oraz kod statusu 404 (przy uyciu metody sendError) w
 *  przeciwnym przypadku. 
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class SearchEngines extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    String searchString = request.getParameter("searchString");
    if ((searchString == null) ||
        (searchString.length() == 0)) {
      reportProblem(response, "Brak zapytania.");
      return;
    }
    /* Klasa URLEncoder zamienia odstpy na znaki "+", a 
     * pozostae znaki, ktre nie s znakami alfanumerycznymi
     * na wyraenia o postaci "%XY"; gdzie XY wartoci danego
     * znaku w kodzie ASCII (lub ISO Latin-1) zapisan w formie
     * liczby szesnastkowej. Przegldarki zawsze automatycznie 
     * koduj wartoci podawane w formularzach w ten  
     * sposb, a zatem metoda getParameter dekoduje je 
     * automatycznie. My jednak przekazujemy te dane do innego
     * serwera, a zatem musimy je ponownie zakodowa.
     */
    searchString = URLEncoder.encode(searchString);
    String numResults = request.getParameter("numResults");
    if ((numResults == null) ||
        (numResults.equals("0")) ||
        (numResults.length() == 0)) {
      numResults = "10";
    }
    String searchEngine =
      request.getParameter("searchEngine");
    if (searchEngine == null) {
      reportProblem(response, "Brak nazwy serwisu wyszukiwawczego.");
      return;
    }
    SearchSpec[] commonSpecs = SearchSpec.getCommonSpecs();
    for(int i=0; i<commonSpecs.length; i++) {
      SearchSpec searchSpec = commonSpecs[i];
      if (searchSpec.getName().equals(searchEngine)) {
        String url =
          searchSpec.makeURL(searchString, numResults);
        response.sendRedirect(url);
        return;
      }
    }
    reportProblem(response, "Nieznany serwis wyszukiwawczy.");
  }

  private void reportProblem(HttpServletResponse response,
                             String message)
      throws IOException {
    response.sendError(response.SC_NOT_FOUND,
                       "<H2>" + message + "</H2>");
  }
  
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}
