package coreservlets;

import java.io.*; 
import javax.servlet.*;
import javax.servlet.http.*;

/** Serwlet generujcy tablic acuchw znakw
 *  i przesyajcy j przy uyciu strumienia
 *  ObjectOutputStream do apletu lub innego klienta
 *  napisanego w jzyku Java.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class QueryGenerator extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    boolean useNumbering = true;
    String useNumberingFlag =
      request.getParameter("useNumbering");
    if ((useNumberingFlag == null) ||
        useNumberingFlag.equals("false")) {
      useNumbering = false;
    }
    String contentType =
      "application/x-java-serialized-object";
    response.setContentType(contentType);
    ObjectOutputStream out =
      new ObjectOutputStream(response.getOutputStream());
    String[] queries = getQueries(useNumbering);
    // Jeli przesyasz niestandardow struktur danych, to
    // bdziesz musia zdefiniowa j jako "implements Serializable".
    out.writeObject(queries);
    out.flush();
  }

  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }

  private String[] getQueries(boolean useNumbering) {
    String[] queries = new String[50];
    for(int i=0; i<queries.length; i++) {
      queries[i] = randomQuery();
      if (useNumbering) {
        queries[i] = "" + (i+1) + ": " + queries[i];
      }
    }
    return(queries);
  }

  // Prawdziwe pytania jakie kiedy kto zada... :-)
  
  private String randomQuery() {
    String[] locations = { "Gdzie ", "Jak " };
    String[] actions =
      { "moge znalezc ", "moge dostac ", "moge kupic " };
    String[] sources =
      { "information ", "zasoby ", "dane ", "odwolania " };
    String[] prepositions = { "dotyczace ", "odnosnie ", "na temat " };
    String[] subjects =
      { "ksiazki Core Servlets i Java Server Pages",
        "tekstu Core Servlets i Java Server Pages",
        "Core Servlets i JavaServer Pages",
        "Core Servlets i JSP",
        "ksiazki Core Web Programming (Java 2 Wydanie)",
        "Core Web Programming (Java 2 Wydanie)",
        "programowania serwletow", "Java Server Pages", "JSP",
        "technologii jezyka Java zastepujacych CGI", 
        "programow pisanych w Javie i wykonywanych na serwerze" };
    String[] endings = { "?", "?", "?", "?!", "?!!!?" };
    String[][] sentenceTemplates =
      { locations, actions, sources,
        prepositions, subjects, endings };
    String query = "";
    for(int i=0; i<sentenceTemplates.length; i++) {
      query = query + randomEntry(sentenceTemplates[i]);
    }
    return(query);
  }

  private String randomEntry(String[] strings) {
    int index = (int)(Math.random()*strings.length);
    return(strings[index]);
  }
}
