package coreservlets;

import java.math.BigInteger;

/** Kilka pomocniczych narzdzi sucych do generacji 
 *  duych liczb losowych typu BigInteger i odnajdywania
 *  liczb pierwszych wikszych od podanej wartoci 
 *  BigInteger.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class Primes {
  // Zwr uwag, e staa BigInteger.ZERO zostaa wprowadzona
  // w JDK 1.2, w tym przykadzie uywam kodu JDK 1.1, aby 
  // zapewni zgodno z wikszoci istniejcych mechanizmw
  // obsugi servletw.
  private static final BigInteger ZERO = new BigInteger("0");
  private static final BigInteger ONE = new BigInteger("1");
  private static final BigInteger TWO = new BigInteger("2");
  
  /* Prawdopodobiestwo popeniania bdu przy okrelaniu
   * czy dana liczba jest liczb pierwsz jest mniejsze
   * od 1/2^ERR_VAL. Mona zaoy e klasa BigInteger
   * uywa algorytmu Millera-Rabina lub jego ekwiwalentu
   * i dlatego nie mona go oszuka stosujc liczby 
   * Carmichael. Wicej szczegw znajdziesz w rozdziale
   * 33.8 ksiki Introduction to Algorithms.
   */
  private static final int ERR_VAL = 100;
  
  public static BigInteger nextPrime(BigInteger start) {
    if (isEven(start))
      start = start.add(ONE);
    else
      start = start.add(TWO);
    if (start.isProbablePrime(ERR_VAL))
      return(start);
    else
      return(nextPrime(start));
  }

  private static boolean isEven(BigInteger n) {
    return(n.mod(TWO).equals(ZERO));
  }

  private static StringBuffer[] digits =
    { new StringBuffer("0"), new StringBuffer("1"),
      new StringBuffer("2"), new StringBuffer("3"),
      new StringBuffer("4"), new StringBuffer("5"),
      new StringBuffer("6"), new StringBuffer("7"),
      new StringBuffer("8"), new StringBuffer("9") };

  private static StringBuffer randomDigit() {
    int index = (int)Math.floor(Math.random() * 10);
    return(digits[index]);
  }
  
  public static BigInteger random(int numDigits) {
    StringBuffer s = new StringBuffer("");
    for(int i=0; i<numDigits; i++) {
      s.append(randomDigit());
    }
    return(new BigInteger(s.toString()));
  }

  /** Prosty program uruchamiany z poziomu wiersza polece,
   *  umoliwiajcy przeprowadzanie testw. Podaj ilo
   *  cyfr, a program wybierze losow liczb pierwsz
   *  o podanej dugoci oraz 50 liczb pierwszych wikszych od niej.
   */
  
  public static void main(String[] args) {
    int numDigits;
    if (args.length > 0)
      numDigits = Integer.parseInt(args[0]);
    else
      numDigits = 150;
    BigInteger start = random(numDigits);
    for(int i=0; i<50; i++) {
      start = nextPrime(start);
      System.out.println("Prime " + i + " = " + start);
    }
  }
}
      
