package coreservlets;

import java.util.*;
import java.math.BigInteger;

/** Tworzy wektor (klasa Vector) duych liczb pierwszych
 *  wykorzystujc do oblicze wtek o niskim priorytecie 
 *  dziaajcy w tle. Klasa udostpnia kilka prostych 
 *  metod dostpu umoliwiajcych prac wielowtkow.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class PrimeList implements Runnable {
  private Vector primesFound;
  private int numPrimes, numDigits;

  /** Metoda odnajduje liczby pierwsze, z ktrych kada
   *  ma dugo co najmniej numDigits liczb. Metod 
   *  mona wywoa w taki sposb aby zwrcia wyniki 
   *  dopiero po cakowitym zakoczeniu oblicze, lub 
   *  aby zakoczya si bezzwocznie - w takim przypadku
   *  bdziesz mg pniej sprawdzi na jakim etapie 
   *  s w danej chwili obliczenia.
   */
  
  public PrimeList(int numPrimes, int numDigits,
                   boolean runInBackground) {
    // Uywam klasy Vector a nie ArrayList
    // aby zachowa zgodnoc z mechanizmami obsugi 
    // korzystajcymi z JDK 1.1
    primesFound = new Vector(numPrimes);
    this.numPrimes = numPrimes;
    this.numDigits = numDigits;
    if (runInBackground) {
      Thread t = new Thread(this);
      // Uywam wtku o niskim priorytecie, aby zbytnio 
      // nie obcia serwera.
      t.setPriority(Thread.MIN_PRIORITY);
      t.start();
    } else {
      run();
    }
  }

  public void run() {
    BigInteger start = Primes.random(numDigits);
    for(int i=0; i<numPrimes; i++) {
      start = Primes.nextPrime(start);
      synchronized(this) {
        primesFound.addElement(start);
      }
    }
  }

  public synchronized boolean isDone() {
    return(primesFound.size() == numPrimes);
  }

  public synchronized Vector getPrimes() {
    if (isDone())
      return(primesFound);
    else
      return((Vector)primesFound.clone());
  }

  public int numDigits() {
    return(numDigits);
  }
  
  public int numPrimes() {
    return(numPrimes);
  }
  
  public synchronized int numCalculatedPrimes() {
    return(primesFound.size());
  }
}
