package coreservlets;

import java.sql.*;

/** Przykad umoliwiajcy przetestowanie rnic w czasie 
 *  wykonania zapytania SQL pomidzy zastosowaniem 
 *  nieprzetworzonych zapyta i zapyta przygotowanych.
 *  Uzyskane wyniki w bardzo duym stopniu zale od 
 *  uywanego sterownika i serwera bazy danych, a ich 
 *  wartoci mog si znaczco rni. Przy mojej
 *  konfiguracji systemu, wykonanie przygotowanego zapytania
 *  w bazie danych Oracle, przy uyciu wolnego poczenia 
 *  modemowego zajmowao poow czasu koniecznego do
 *  wykonania tego samego zapytania w wersji nieprzetworzonej;
 *  W przypadku wykorzystania szybkiego poczenia LAN,
 *  wykonanie zapytania przygotowanego zajmowao 70% czasu
 *  koniecznego do wykonania tego samego zapytania w formie
 *  nieprzetworzonej. W przypadku wykorzystania bazy 
 *  danych Sybase, uzyskane wyniki nie zaleay od 
 *  szybkoci uywanego poczenia.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class PreparedStatements {
  public static void main(String[] args) {
    if (args.length < 5) {
      printUsage();
      return;
    }
    String vendorName = args[4];
    int vendor = DriverUtilities.getVendor(vendorName);
    if (vendor == DriverUtilities.UNKNOWN) {
      printUsage();
      return;
    }
    String driver = DriverUtilities.getDriver(vendor);
    String host = args[0];
    String dbName = args[1];
    String url =
      DriverUtilities.makeURL(host, dbName, vendor);
    String username = args[2];
    String password = args[3];
    // Uyj "print" tylko po to by potwierdzi, e wszystko jest OK 
    // nie uywaj przy okrelaniu czasw wykonywania zapyta.
    boolean print = false;
    if ((args.length > 5) && (args[5].equals("print"))) {
      print = true;
    }
    Connection connection =
      getConnection(driver, url, username, password);
    if (connection != null) {
      doPreparedStatements(connection, print);
      doRawQueries(connection, print);
    }
  }

  private static void doPreparedStatements(Connection conn,
                                           boolean print) {
    try {
      String queryFormat =
        "SELECT lastname FROM employees WHERE salary > ?";
      PreparedStatement statement =
        conn.prepareStatement(queryFormat);
      long startTime = System.currentTimeMillis();
      for(int i=0; i<40; i++) {
        statement.setFloat(1, i*5000);
        ResultSet results = statement.executeQuery();
        if (print) {
          showResults(results);
        }
      }
      long stopTime = System.currentTimeMillis();
      double elapsedTime = (stopTime - startTime)/1000.0;
      System.out.println("40-krotne wykonanie przygotowanego " +
                         "zapytania zajo " +
                         elapsedTime + " sekund.");
    } catch(SQLException sqle) {
      System.out.println("Bd przy wykonywaniu zapytania: " + sqle);
    }
  }

  public static void doRawQueries(Connection conn,
                                  boolean print) {
    try {
      String queryFormat =
        "SELECT lastname FROM employees WHERE salary > ";
      Statement statement = conn.createStatement();
      long startTime = System.currentTimeMillis();
      for(int i=0; i<40; i++) {
        ResultSet results =
          statement.executeQuery(queryFormat + (i*5000));
        if (print) {
          showResults(results);
        }
      }
      long stopTime = System.currentTimeMillis();
      double elapsedTime = (stopTime - startTime)/1000.0;
      System.out.println("40-krotne wykonanie zapytania zajo " +
                         elapsedTime + " sekund.");
    } catch(SQLException sqle) {
      System.out.println("Bd przy wykonywaniu zapytania: " + sqle);
    }
  } 

  private static void showResults(ResultSet results)
      throws SQLException {
    while(results.next()) {
      System.out.print(results.getString(1) + " ");
    }
    System.out.println();
  }
    
  private static Connection getConnection(String driver,
                                          String url,
                                          String username,
                                          String password) {
    try {
      Class.forName(driver);
      Connection connection =
        DriverManager.getConnection(url, username, password);
      return(connection);
    } catch(ClassNotFoundException cnfe) {
      System.err.println("Bd adowania sterownika: " + cnfe);
      return(null);
    } catch(SQLException sqle) {
      System.err.println("Bd przy nawizywaniu poczenia: " + sqle);
      return(null);
    }
  }

  private static void printUsage() {
    System.out.println("Uycie: PreparedStatements komputer " +
                       "nazwaBazyDanych nazwaUytkownika haso " +
                       "oracle|sybase [print].");
  }
}
