package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

/** Servlet ilustruje znaczenie trwaych pocze HTTP
 *  dla stron zawierajcych wiele obrazw, apletw, lub
 *  inn zawarto, ktrej pobranie wymagaoby utworzenia
 *  oddzielnego poczenia.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class PersistentConnection extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    ByteArrayOutputStream byteStream =
      new ByteArrayOutputStream(7000);
    PrintWriter out = new PrintWriter(byteStream, true);
    String persistenceFlag =
      request.getParameter("usePersistence");
    boolean usePersistence =
      ((persistenceFlag == null) ||
       (!persistenceFlag.equals("no")));
    String title;
    if (usePersistence) {
      title = "Uywam trwaych pocze";
    } else {
      title = "Nie uywam trwaych pocze";
    }
    out.println(ServletUtilities.headWithTitle(title) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=\"CENTER\">" + title + "</H1>");
    int numImages = 100;
    for(int i=0; i<numImages; i++) {
      out.println(makeImage(i, usePersistence));
    }
    out.println("</BODY></HTML>");
    if (usePersistence) {
      response.setContentLength(byteStream.size());
    }
    byteStream.writeTo(response.getOutputStream());
  }

  private String makeImage(int n, boolean usePersistence) {
    String file =
      "/servlet/coreservlets.ImageRetriever?gifLocation=" +
      "/Misc/bullets/bullet" + n + ".gif";
    if (!usePersistence)
      file = file + "&usePersistence=no";
    return("<IMG SRC=\"" + file + "\"\n" +
           "     WIDTH=6 HEIGHT=6 ALT=\"\">");
  }    
    
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}
