package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Przykad wykorzystujcy inicjalizacj apletw 
 *  oraz metod getLastModified
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 */

public class LotteryNumbers extends HttpServlet {
  private long modTime;
  private int[] numbers = new int[10];

  /** Metoda init jest wywoywana wycznie raz, 
   *  bezporednio po zaadowaniu servletu do pamici
   *  i przed obsueniem pierwszego dania
   */
  
  public void init() throws ServletException {
    // Zaokrglamy do penych sekund (1000 milisekund)
    modTime = System.currentTimeMillis()/1000*1000;
    for(int i=0; i<numbers.length; i++) {
      numbers[i] = randomNum();
    }
  }
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    String title = "Szczliwe numery";
    out.println(ServletUtilities.headWithTitle(title) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=CENTER>" + title + "</H1>\n" +
                "<B>Bazujc na wnikliwych badaniach " +
                "kosmicznie bezsensownych trendw, psychicznych bzdur " +
                "i bardzo mdrej naukowej paplaninie, " +
                "wybralimy " + numbers.length +
                " Twoich szczliwych numerkw.</B>" +
                "<OL>");
    for(int i=0; i<numbers.length; i++) {
      out.println("  <LI>" + numbers[i]);
    }
    out.println("</OL>" +
                "</BODY></HTML>");
  }

  /** Standardowa metoda service porwnuje t dat
   *  z dat okrelon w nagwku dania If-Modified-Since
   *  Jeli data zwrcona przez metod getLastModified jest
   *  pniejsza, lub jeli nie ma nagwka If-Modified-Since
   *  to metoda doGet jest wywoywana w zwyczajny sposb.
   *  Jeli jednak data zwrcona przez metod getLastModified
   *  jest taka sama lub wczeniejsza to metoda service wysya
   *  do klienta odpowied 304 (Not Modified) - (nie zmieniony)
   *  i <B>nie</B> wywouje metody doGet. W takiej sytuacji 
   *  przegldarka powinna uy strony przechowywanej w pamici
   *  podrcznej.
   */
  
  public long getLastModified(HttpServletRequest request) {
    return(modTime);
  }

  // Liczba pseudolosowa z zakresu od 0 do 99.
  
  private int randomNum() {
    return((int)(Math.random() * 100));
  }
}
