package coreservlets;

/** Opisuje element katalogu dla internetowego sklepu.
 *  identyfikator (itemID) unikalnie identyfikuje kady
 *  element, krtki opis (shortDescription) zawiera  
 *  krtkie informacje o towarze (takie jak nazw 
 *  autora i tytu ksiki), a dugi opis (longDescription) 
 *  to kilka zda dokadniej opisujcych dany towar; w kocu
 *  cena (cost) to jednostkowa cena towaru.
 *  Zarwno krtki jak i dugi opis moe zawiera kod HTML.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class Item {
  private String itemID;
  private String shortDescription;
  private String longDescription;
  private double cost;

  public Item(String itemID, String shortDescription,
              String longDescription, double cost) {
    setItemID(itemID);
    setShortDescription(shortDescription);
    setLongDescription(longDescription);
    setCost(cost);
  }
    
  public String getItemID() {
    return(itemID);
  }

  protected void setItemID(String itemID) {
    this.itemID = itemID;
  }

  public String getShortDescription() {
    return(shortDescription);
  }

  protected void setShortDescription(String shortDescription) {
    this.shortDescription = shortDescription;
  }

  public String getLongDescription() {
    return(longDescription);
  }

  protected void setLongDescription(String longDescription) {
    this.longDescription = longDescription;
  }

  public double getCost() {
    return(cost);
  }

  protected void setCost(double cost) {
    this.cost = cost;
  }
}
  
