package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Servlet ktry odczytuje plik GIF z lokalnego systemu
 *  i przesya go do klienta wykorzystujc przy tym odpowiedni
 *  typ MIME. Servlet wykorzystuje nagwek Content-Type aby
 *  umoliwi wykorzystanie trwaych pocze HTTP, chyba
 *  e klient zabroni tego uywajc parametru 
 *  "usePersistence=no". Klasa uywana przez servlet 
 *  PersistentConnection.
 *  <P>
 *  <i>Nie</i> naley instalowa tego servletu w sposb trway
 *  na publicznie dostpnych serwerach, gdy umoliwia on 
 *  dostp do obrazw, ktre nie koniecznie znajduj si 
 *  w drzewie katalogw dostpnych dla serwera WWW.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class ImageRetriever extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    String gifLocation = request.getParameter("gifLocation");
    if ((gifLocation == null) ||
        (gifLocation.length() == 0)) {
      reportError(response, "Podany obraz nie zosta odnaleziony");
      return;
    }
    String file = getServletContext().getRealPath(gifLocation);
    try {
      BufferedInputStream in =
        new BufferedInputStream(new FileInputStream(file));
      ByteArrayOutputStream byteStream =
        new ByteArrayOutputStream(512);
      int imageByte;
      while((imageByte = in.read()) != -1) {
        byteStream.write(imageByte);
      }
      in.close();
      String persistenceFlag =
      request.getParameter("usePersistence");
      boolean usePersistence =
        ((persistenceFlag == null) ||
         (!persistenceFlag.equals("no")));
      response.setContentType("image/gif");
      if (usePersistence) {
        response.setContentLength(byteStream.size());
      } 
      byteStream.writeTo(response.getOutputStream());
    } catch(IOException ioe) {
      reportError(response, "Bd: " + ioe);
    }
  }

  public void reportError(HttpServletResponse response,
                          String message)
      throws IOException {
    response.sendError(response.SC_NOT_FOUND,
                       message);
  }
}

