package coreservlets;

import java.sql.*;

/** Tworzy prost tabel o nazwie "fruits" w bazie 
 *  danych Oracle lub Sybase.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class FruitCreation {
  public static void main(String[] args) {
    if (args.length < 5) {
      printUsage();
      return;
    }
    String vendorName = args[4];
    int vendor = DriverUtilities.getVendor(vendorName);
    if (vendor == DriverUtilities.UNKNOWN) {
      printUsage();
      return;
    }
    String driver = DriverUtilities.getDriver(vendor);
    String host = args[0];
    String dbName = args[1];
    String url =
      DriverUtilities.makeURL(host, dbName, vendor);
    String username = args[2];
    String password = args[3];
    String format =
      "(quarter int, " +
      "apples int, applesales float, " +
      "oranges int, orangesales float, " +
      "topseller varchar(16))";
    String[] rows =
    { "(1, 32248, 3547.28, 18459, 3138.03, 'Maria')",
      "(2, 35009, 3850.99, 18722, 3182.74, 'Bob')",
      "(3, 39393, 4333.23, 18999, 3229.83, 'Joe')",
      "(4, 42001, 4620.11, 19333, 3286.61, 'Maria')" };
    Connection connection = 
      DatabaseUtilities.createTable(driver, url,
                                    username, password,
                                    "fruits", format, rows,
                                    false);
    // Sprawdzenie czy tabela zostaa poprawnie utworzona.
    // W celu zwikszenia efektywnoci wykorzystywane 
    // jest to samo poczenie.
    DatabaseUtilities.printTable(connection, "fruits",
                                 11, true);
  }

  private static void printUsage() {
     System.out.println("Uycie: FruitCreation komputer nazwaBazyDanych " +
                        "nazwaUytkownika haso oracle|sybase.");
  }
}
