package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;

/** Zmodyfikowana wersja serwletu 
 *  ConnectionPoolServlet ktra NIE KORZYSTA z puli
 *  pocze. Serwlet ten jest wykorzystywany przy
 *  porwnywaniu zyskw czasowych jakie daje 
 *  stosowanie pul pocze.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class ConnectionPoolServlet3 extends HttpServlet {
  private String url, username, password;
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    String table;
    String query =
      "SELECT firstname, lastname " +
      " FROM employees WHERE salary > 70000";
    try {
      Connection connection =
        DriverManager.getConnection(url, username, password);
      DBResults results =
        DatabaseUtilities.getQueryResults(connection,
                                          query, true);
      table = results.toHTMLTable("#FFAD00");
    } catch(Exception e) {
      table = "Exception: " + e;
    }
    response.setContentType("text/html");
    // Zadaj aby przegldarka nie przechowywaa wynikw 
    // w pamici podrcznej. Wicej informacji na ten temat
    // znajdziesz w podrozdziale 7.2 ksiki Java Servlet i
    // Java Server Pages.
    response.setHeader("Pragma", "no-cache"); // HTTP 1.0
    response.setHeader("Cache-Control", "no-cache"); // HTTP 1.1
    PrintWriter out = response.getWriter();
    String title = "Test wykorzystania pul pocze (*Bez* uycia puli)";
    out.println(ServletUtilities.headWithTitle(title) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<CENTER>\n" +
                table + "\n" +
                "</CENTER>\n</BODY></HTML>");
  }
  
  public void init() {
    try {
      int vendor = DriverUtilities.SYBASE;
      String driver = DriverUtilities.getDriver(vendor);
      Class.forName(driver);
      String host = "128.220.101.65";
      String dbName = "605741";
      url = DriverUtilities.makeURL(host, dbName, vendor);
      username = "hall";
      password = "hall";
    } catch(ClassNotFoundException e) {
      System.err.println("Bd podczas inicjalizacji: " + e);
      getServletContext().log("Bd podczas inicjalizacji: " + e);
    }
  }
}
