package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

/** Klasa bazowa stron prezentujcych towary z katalogu.
 *  Servlety dziedziczce od tej klasy bazowej musz
 *  okreli wywietlane elementy katalogu oraz tytu
 *  strony <i>zanim</i> servlet zostanie wykonany.
 *  W tym celu w metodzie init takiego servletu naley
 *  wywoa metody setItems oraz setTitle klasy bazowej.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public abstract class CatalogPage extends HttpServlet {
  private Item[] items;
  private String[] itemIDs;
  private String title;

  /** Dysponujc tablic identyfikatorw towarw, odszukaj
   *  je w katalogu (Catalog) i zapisz odpowiadajce im
   *  obiekty Item do tablicy items. Obiekty Item zawieraj
   *  krtki opis, peny opis oraz cen towaru, a ich 
   *  unikalnym kluczem jest identyfikator towaru.
   *  <P>
   *  Servlety dziedziczce po klasie CatalogPage 
   *  <b>musz</b> wywoywa t metod (zazwyczaj 
   *  w metodzie init) zanim servlet zostanie wywoany.
   */
  
  protected void setItems(String[] itemIDs) {
    this.itemIDs = itemIDs;
    items = new Item[itemIDs.length];
    for(int i=0; i<items.length; i++) {
      items[i] = Catalog.getItem(itemIDs[i]);
    }
  }

  /** Okrela tytu strony, ktry jest wywietlany na
   *  stronie wynikowej w nagwku <H1>.
   *  <P>
   *  Servlety dziedziczce po klasie CatalogPage 
   *  <b>musz</b> wywoywa t metod (zazwyczaj 
   *  w metodzie init) zanim servlet zostanie wywoany.
   */
  
  protected void setTitle(String title) {
    this.title = title;
  }

  /** Metoda w pierwszej kolejnoci wywietla tytu, a nastpnie
   *  dla kadego towaru z katalogu, ktry ma by przedstawiony
   *  na danej stronie, wywietla jego krtki opis (w nagwku
   *  <H2>), cen (w nawiasach) oraz peny opis poniej.
   *  Poniej kadego towaru wywietlany jest przycisk umoliwiajcy
   *  zoenie zamwienia dotyczcego danego towaru - informacje
   *  przesyane s do servletu OrderPage.
   *  <P>
   *  Aby zobaczy kod HTML generowany przez t metod, naley
   *  wykona servlet KidsBooksPage lub TechBooksPage (obie 
   *  te klasy dziedzicz po abstrakcyjnej klasie CatalogPage)
   *  i wybra opcj "Wywietl kod rdowy" (lub jej ekwiwalent)
   *  w przegldarce.
   */
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    if (items == null) {
      response.sendError(response.SC_NOT_FOUND,
                         "Brak towarw.");
      return;
    }
    PrintWriter out = response.getWriter();
    out.println(ServletUtilities.headWithTitle(title) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=\"CENTER\">" + title + "</H1>");
    Item item;
    for(int i=0; i<items.length; i++) {
      out.println("<HR>");
      item = items[i];
      // Wywietl informacje o bdzie jeli klasa potomna
      // podaa identyfikator towaru ktrego nie ma w katalogu
      if (item == null) {
        out.println("<FONT COLOR=\"RED\">" +
                    "Nieznany identyfikator towaru " + itemIDs[i] +
                    "</FONT>");
      } else {
        out.println();
        String formURL =
          "/servlet/coreservlets.OrderPage";
        // Adresy URL odwoujce si do tej samej witryny naley
        // przeksztaci przy uyciu metody encodeURL.
        formURL = response.encodeURL(formURL);
        out.println
          ("<FORM ACTION=\"" + formURL + "\">\n" +
           "<INPUT TYPE=\"HIDDEN\" NAME=\"itemID\" " +
           "       VALUE=\"" + item.getItemID() + "\">\n" +
           "<H2>" + item.getShortDescription() +
           " ($" + item.getCost() + ")</H2>\n" +
           item.getLongDescription() + "\n" +
           "<P>\n<CENTER>\n" +
           "<INPUT TYPE=\"SUBMIT\" " +
           "VALUE=\"Dodaj do koszyka\">\n" +
           "</CENTER>\n<P>\n</FORM>");
}
    }
    out.println("<HR>\n</BODY></HTML>");
  }

  /** dania POST i GET maj by obsugiwane tak samo. */
  
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}
