package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Servlet wywietlajcy fragment listingu kodu napisanego
 *  w jzyku Java. Fragment ten nie zosta przefiltrowany 
 *  w celu odszukania i zastpienia znakw specjalnych HTML
 *  (w tym przypadku s to znaki < i >).
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class BadCodeServlet extends HttpServlet {
  private String codeFragment =
    "if (a<b) {\n" +
    "  doThis();\n" +
    "} else {\n" +
    "  doThat();\n" +
    "}\n";

  public String getCodeFragment() {
    return(codeFragment);
  }
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    String title = "Instrukcja 'if' Javy";
    
    out.println(ServletUtilities.headWithTitle(title) +
                "<BODY>\n" +
                "<H1>" + title + "</H1>\n" +
                "<PRE>\n" +
                getCodeFragment() +
                "</PRE>\n" +
                "Zauwa, e <I>musisz</I> uy nawiasw\n" +
                "gdy klauzule 'if' lub 'else' zawieraj\n" +
                "wiecj ni jedno wyraenie.\n" +
                "</BODY></HTML>");
  }
}
