import java.awt.*;

/** Pole tekstowe (TextField) wraz z odpwiadajc mu etykiet (Label).
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 */

public class LabeledTextField extends Panel {
  private Label label;
  private TextField textField;
  
  public LabeledTextField(String labelString,
                          Font labelFont,
                          int textFieldSize,
                          Font textFont) {
    setLayout(new FlowLayout(FlowLayout.LEFT));
    label = new Label(labelString, Label.RIGHT);
    if (labelFont != null)
      label.setFont(labelFont);
    add(label);
    textField = new TextField(textFieldSize);
    if (textFont != null)
      textField.setFont(textFont);
    add(textField);
  }

  public LabeledTextField(String labelString,
                          String textFieldString) {
    this(labelString, null, textFieldString,
         textFieldString.length(), null);
  }

  public LabeledTextField(String labelString,
                          int textFieldSize) {
    this(labelString, null, textFieldSize, null);
  }
  
  public LabeledTextField(String labelString,
                          Font labelFont,
                          String textFieldString,
                          int textFieldSize,
                          Font textFont) {
    this(labelString, labelFont,
         textFieldSize, textFont);
    textField.setText(textFieldString);
  }

  /** Etykieta (Label) znajdujca si po lewej stronie pola
   *  LabeledTextField.
   *  Aby obsuy etykiet wykorzystaj kod o nastpujcej
   *  postaci:
   *  <PRE>
   *    LabeledTextField ltf = new LabeledTextField(...);
   *    ltf.getLabel().metodaObslugiEtykiety(...);
   *  </PRE>
   *
   *  patrz metoda getTextField
   */
  
  public Label getLabel() {
    return(label);
  }

  /** Pole tekstowe (TextField) znajdujce si po prawej
   *  stronie pola LabeledTextField.
   *
   *  patrz metoda getLabel
   */
  
  public TextField getTextField() {
    return(textField);
  }
}
