import java.awt.*;
import java.net.*;
import java.io.*;

/** Bazowa klasa implementujca klienta sieciowego,
 *  uywana w aplikacji WebClient.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 */

public class HttpClient extends NetworkClient {
  private String requestLine;
  private String[] requestHeaders;
  private TextArea outputArea;
  private Interruptible app;
  
  public HttpClient(String host, int port,
                    String requestLine, String[] requestHeaders,
                    TextArea outputArea, Interruptible app) {
    super(host, port);
    this.requestLine = requestLine;
    this.requestHeaders = requestHeaders;
    this.outputArea = outputArea;
    this.app = app;
    if (checkHost(host))
      connect();
  }

  protected void handleConnection(Socket uriSocket)
      throws IOException {
    try {
      PrintWriter out = SocketUtil.getWriter(uriSocket);
      BufferedReader in = SocketUtil.getReader(uriSocket);
      outputArea.setText("");
      out.println(requestLine);
      for(int i=0; i<requestHeaders.length; i++) {
        if (requestHeaders[i] == null)
          break;
        else
          out.println(requestHeaders[i]);
      }
      out.println();
      String line;
      while ((line = in.readLine()) != null &&
             !app.isInterrupted())
        outputArea.append(line + "\n");
      if (app.isInterrupted())
        outputArea.append("---- Pobieranie zostao przerwane ----");
    } catch(Exception e) {
      outputArea.setText("Bd: " + e);
    }
  }

  private boolean checkHost(String host) {
    try {
      InetAddress.getByName(host);
      return(true);
    } catch(UnknownHostException uhe) {
      outputArea.setText("Za nazwa hosta: " + host);
      return(false);
    }
  }
}
