import java.net.*;
import java.io.*;

/** Wielowtkowa wersja serwera EchoServer.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class ThreadedEchoServer extends EchoServer
                                implements Runnable {
  public static void main(String[] args) {
    int port = 8088;
    if (args.length > 0) {
      try {
        port = Integer.parseInt(args[0]);
      } catch(NumberFormatException nfe) {}
    }
    ThreadedEchoServer echoServer =
      new ThreadedEchoServer(port, 0);
    echoServer.serverName = "Wielowtkowa wersja serwera EchoServer";
  }

  public ThreadedEchoServer(int port, int connections) {
    super(port, connections);
  }

  /** Nowa wersja metody handleConnection uruchamia
   *  nowy wtek. Ten nowy wtek odwoa si z powrotem
   *  do <i>starej</i> wersji metody handleConnection,
   *  przez co serwer bdzie dziaa tak samo, tylko w
   *  sposb wielowtkowy. Wtek przechowuje egzemplarz
   *  obiektu klasy Socket, gdy metoda run nie pobiera
   *  adnych argumentw, oraz poniewa przechowanie
   *  go w zmiennej instancyjnej moe grozi utrat 
   *  tego obiektu w przypadku gdyby inny wtek 
   *  zosta uruchomiony zanim metoda run bdzie miaa
   *  okazj skopiowa odwoanie do gniazda.
   */
                                  
  public void handleConnection(Socket server) {
    Connection connectionThread = new Connection(this, server);
    connectionThread.start();
  }
    
  public void run() {
    Connection currentThread =
      (Connection)Thread.currentThread();
    try {
      super.handleConnection(currentThread.serverSocket);
    } catch(IOException ioe) {
      System.out.println("IOException: " + ioe);
      ioe.printStackTrace();
    }
  }
}

/** To jest wycznie obiekt klasy Thread dysponujcy
 *  polem umoliwiajcym przechowanie egzemplarza 
 *  obiektu klasy Socket. Obiekty tej klasy s uywane
 *  do bezpiecznego przekazywania obiektw Socket z 
 *  metody handleConnection do metody run.
 */

class Connection extends Thread {
  protected Socket serverSocket;

  public Connection(Runnable serverObject,
                    Socket serverSocket) {
    super(serverObject);
    this.serverSocket = serverSocket;
  }
}
