import java.net.*;
import java.io.*;

/** Uproszczony sposb tworzenia egzemplarzy obiektw
 *  klas PrintWriter oraz BufferedReader skojarzonych
 *  z gniazdem (egzemplarzem obiektu klasy Socket).
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class SocketUtil {
  /** Tworzy BufferedReader pobierajcy nadsyane informacje. */
  
  public static BufferedReader getReader(Socket s)
      throws IOException {
    return(new BufferedReader(
	     new InputStreamReader(s.getInputStream())));
  }

  /** Tworzy PrintWriter wysyajcy wyjciowe informacje.
   *  Ten obiekt bdzie automatycznie oprnia strumie
   *  wyjciowy w momencie wywoania metody println.
   */
  
  public static PrintWriter getWriter(Socket s)
      throws IOException {
    // drugi argument o wartoci true oznacza, e naley 
    // stosowa automatyczne oprnianie strumienia wyjciowego.
    return(new PrintWriter(s.getOutputStream(), true));
  }
}
