import java.net.*;
import java.io.*;
import java.util.*;

/** Prosty serwer HTTP, ktry generuje stron WWW
 *  przedstawiajc wszystkie informacje przesane
 *  z klienta (zazwyczaj przegldarki) w daniu HTTP.
 *  Aby uy programu naley go uruchomi w wybranym
 *  komputerze, podajc numer portu na ktrym
 *  ma dziaa (jeli nie chcesz by dziaa na domylnym
 *  porcie o numerze 8088). Nastpnie, na tym samym lub
 *  innym komputerze, uruchom przegldark WWW 
 *  i odwoaj si do adresu http://komputer:8088/jakasStrona.
 *  Wywietlona, wynikowa strona bdzie prezentowa informacje
 *  przesane przez przegldark w daniu HTTP. W przypadku
 *  testowania serwletw lub programw CGI, naley poda
 *  adres http://komputer:8088/jakisProgram w atrybucie 
 *  ACTION formularza. Mona przesya dane zarwno metod 
 *  GET jak i POST; niezalenie od uytej metody 
 *  wyniki bd przedstawia wszystkie informacje 
 *  przesane przez przegldark.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall & Larry Brown; mona kopiowa i modyfikowa bez ogranicze.
 */

public class EchoServer extends NetworkServer {
  protected int maxRequestLines = 50;
  protected String serverName = "EchoServer";

  /** Podaje numer portu jak argument wywoania programu.
   *  Jeli numer portu nie zostanie podany, program
   *  uyje domylnego portu o numerze 8088.
   */

  public static void main(String[] args) {
    int port = 8088;
    if (args.length > 0) {
      try {
        port = Integer.parseInt(args[0]);
      } catch(NumberFormatException nfe) {}
    }
    new EchoServer(port, 0);
  }

  public EchoServer(int port, int maxConnections) {
    super(port, maxConnections);
    listen();
  }

  /** Przesania metod handleConnection klasy
   *  NetworkServer. Metoda odczytuje kady przesany
   *  wiersz informacji, zapisuje go w tablicy acuchw
   *  znakw, a nastpnie umieszcza na stronie WWW
   *  wewntrz elementu PRE. Tak utworzona strona WWW
   *  jest przesyana do przegldarki.
   */

  public void handleConnection(Socket server)
      throws IOException{
    System.out.println
        (serverName + ": odebrano poczenie z " +
         server.getInetAddress().getHostName());
    BufferedReader in = SocketUtil.getReader(server);
    PrintWriter out = SocketUtil.getWriter(server);
    String[] inputLines = new String[maxRequestLines];
    int i;
    for (i=0; i<maxRequestLines; i++) {
      inputLines[i] = in.readLine();
      if (inputLines[i] == null) // Klient zamkn poczenie.
        break;
      if (inputLines[i].length() == 0) { // Pusty wiersz.
        if (usingPost(inputLines)) {
          readPostData(inputLines, i, in);
          i = i + 2;
        }
        break;
      }
    }
    printHeader(out);
    for (int j=0; j<i; j++) {
      out.println(inputLines[j]);
    }
    printTrailer(out);
    server.close();
  }

  // Przesya standardow odpowied HTTP i pocztek standardowej
  // strony WWW. Dla uzyskania zgodnoci ze wszystkimi klientami
  // wykorzystywany jest protok HTTP 1.0.

  private void printHeader(PrintWriter out) {
    out.println
      ("HTTP/1.0 200 OK\r\n" +
       "Server: " + serverName + "\r\n" +
       "Content-Type: text/html\r\n" +
       "\r\n" +
       "<!DOCTYPE HTML PUBLIC " +
         "\"-//W3C//DTD HTML 4.0 Transitional//EN\">\n" +
       "<HTML>\n" +
       "<HEAD>\n" +
       "  <TITLE>" + serverName + " Wyniki</TITLE>\n" +
       "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-2\">" +
       "</HEAD>\n" +
       "\n" +
       "<BODY BGCOLOR=\"#FDF5E6\">\n" +
       "<H1 ALIGN=\"CENTER\">" + serverName +
         " Wyniki</H1>\n" +
       "Oto wiersz dania oraz nagwki dania HTTP \n" +
       "przesane przez Twoj przegldark:\n" +
       "<PRE>");
  }

  // Generuje koniec standardowej strony WWW.
  
  private void printTrailer(PrintWriter out) {
    out.println
      ("</PRE>\n" +
       "</BODY>\n" +
       "</HTML>\n");
  }

  // Normalne dania dotyczce stron WWW wykorzystuj
  // metod GET, a zatem ten serwer moe odczytywa
  // przesyane informacje kolejno, po jednym wierszu.
  // Jednak formularze HTML mog take uywa metody POST.
  // W takim przypadku naley okreli liczb przesyanych 
  // bajtw, aby byo wiadomo ile dodatkowych bajtw 
  // informacji naley odczyta po zakoczeniu pobierania 
  // nagwkw dania HTTP.

  private boolean usingPost(String[] inputs) {
    return(inputs[0].toUpperCase().startsWith("POST"));
  }

  private void readPostData(String[] inputs, int i,
                            BufferedReader in)
      throws IOException {
    int contentLength = contentLength(inputs);
    char[] postData = new char[contentLength];
    in.read(postData, 0, contentLength);
    inputs[++i] = new String(postData, 0, contentLength);
  }

  // Dysponujc wierszem rozpoczynajcym si od acucha znakw
  // Content-Length, metoda zwraca zapisan w tym wierszu
  // liczb cakowit.
  
  private int contentLength(String[] inputs) {
    String input;
    for (int i=0; i<inputs.length; i++) {
      if (inputs[i].length() == 0)
        break;
      input = inputs[i].toUpperCase();
      if (input.startsWith("CONTENT-LENGTH"))
        return(getLength(input));
    }
    return(0);
  }

  private int getLength(String length) {
    StringTokenizer tok = new StringTokenizer(length);
    tok.nextToken();
    return(Integer.parseInt(tok.nextToken()));
  }
}           