package coreservlets;

import java.sql.*;
import coreservlets.beans.*;

/** Program tworzy prostą tabelę o nazwie "music".
 *  Baza danych w jakiej zostanie utworzona tabela jest
 *  określana w wierszu wywołania programu. Sterownik
 *  bazy danych jest wczytywany przy użyciu klasy 
 *  DriverUtilities.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall & Larry Brown; można kopiować i modyfikować bez ograniczeń.
 */

public class CreateMusicTable {
  public static void main(String[] args) {
    if (args.length < 5) {
      printUsage();
      return;
    }
    String vendor = args[4];
    // Aby wczytać dane sterownika z pliku XML, należy 
    // użyć metody DriverUtilities2.loadDrivers()
    DriverUtilities.loadDrivers();
    if (!DriverUtilities.isValidVendor(vendor)) {
      printUsage();
      return;
    }
    String driver = DriverUtilities.getDriver(vendor);
    String host = args[0];
    String dbName = args[1];
    String url =
      DriverUtilities.makeURL(host, dbName, vendor);
    String username = args[2];
    String password = args[3];
    String format =
      "(id INTEGER, composer VARCHAR(16), " +
      " concerto VARCHAR(24), available INTEGER, " +
      " price FLOAT)";
    String[] rows = {
      "(1, 'Mozart',      'Nr. 21 cis-moll',  7, 24.99)",
      "(2, 'Beethoven',   'Nr. 3 c-moll',     28, 10.99)",
      "(3, 'Beethoven',   'Nr. 5 Es-dur',     33, 10.99)",
      "(4, 'Rachmaninov', 'Nr. 2 c-moll',     9, 18.99)",
      "(5, 'Mozart',      'Nr. 24 c-moll',    11, 21.99)",
      "(6, 'Beethoven',   'Nr. 4 G-dur',      33, 12.99)",
      "(7, 'Liszt',       'Nr. 1 Es-dur',     48, 10.99)" };
    Connection connection =
      ConnectionInfoBean.getConnection(driver, url,
                                       username, password);
    createTable(connection, "music", format, rows);
    try {
      connection.close();
    } catch(SQLException sqle) {
      System.err.println("Problem z nawiązaniem połączenia: " + sqle);
    }
  }

  /** Metoda tworzy tabelę o podanym formacie i zawartości. */

  private static void createTable(Connection connection,
                                  String tableName,
                                  String tableFormat,
                                  String[] tableRows) {
    try {
      Statement statement = connection.createStatement();
      // Usunięcie istniejącej tabeli (jeśli jest), bez 
      // zwracania błędów jeśli jej nie ma. Właśnie po to
      // został zastosowany osobny blok try-catch.
      try {
        statement.execute("DROP TABLE " + tableName);
      } catch(SQLException sqle) {}
      String createCommand =
        "CREATE TABLE " + tableName + " " + tableFormat;
      statement.execute(createCommand);
      String insertPrefix =
        "INSERT INTO " + tableName + " VALUES";
      for(int i=0; i<tableRows.length; i++) {
        statement.execute(insertPrefix + tableRows[i]);
      }
    } catch(SQLException sqle) {
      System.err.println("Błąd tworzenia tabeli: " + sqle);
    }
  }

  private static void printUsage() {
     System.out.println("Sposób użycia: CreateMusicTable komputer nazwaBazy " +
                       "nazwaUżytkownika hasło typ.");
  }
}  