package coreservlets.beans;

import java.sql.*;
import java.util.*;

/** Komponent służący do realizacji transakcji JDBC. Po 
 *  podaniu połączenia, komponent wykonuje grupę poleceń SQL
 *  tworzących jedną transakcję. Wykonanie poleceń następuje 
 *  po wywołaniu metody execute. W razie zgłoszenia wyjątku
 *  SQLException wszelkie wykonane wcześniej polecenia SQL 
 *  są wycofywane.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall & Larry Brown; można kopiować i modyfikować bez ograniczeń.
 */

public class TransactionBean {
  private Connection connection;

  public void setConnection(Connection connection) {
    this.connection = connection;
  }

  public void setConnection(String driver, String url,
                            String username, String password) {
    setConnection(ConnectionInfoBean.getConnection(
                     driver, url, username, password));
  }

  public Connection getConnection() {
    return(connection);
  }

  public void execute(List list) throws SQLException {
     execute((String[])list.toArray(new String[list.size()]));
  }

  public void execute(String transaction)
      throws SQLException {
    execute(new String[] { transaction });
  }

  /** Metoda wykonuje grupę poleceń SQL jako jedną 
   *  transakcję. W razie wystąpienia wyjątku 
   *  SQLException wszystkie wykonane wcześniej polecenia
   *  są wycofywane.
   */

    public void execute(String[] transaction)
      throws SQLException {
    if (connection == null) {
      throw new SQLException("Brak połączenia z bazą danych.");
    }
    boolean autoCommit = connection.getAutoCommit();
    try {
      connection.setAutoCommit(false);
      Statement statement = connection.createStatement();
      for(int i=0; i<transaction.length; i++) {
        statement.execute(transaction[i]);
      }
      statement.close();
      connection.commit();
    } catch(SQLException sqle) {
      connection.rollback();
      throw sqle;
    } finally {
      connection.setAutoCommit(autoCommit);
    }
  }

  public void close() {
    if (connection != null) {
      try {
        connection.close();
      } catch(SQLException sqle) {
        System.err.println(
          "Nie udało się zamknąć połączenia: " + sqle);
      } finally {
        connection = null;
      }
    }
  }
}       