package coreservlets;

import java.sql.*;

/** Przykład JDBC, który nawiązuje połączenie z bazą danych 
 *	Northwind programu Microsoft Access, wykonuje proste zapytanie
 *  SQL pobierające dane z tabeli pracowników i wyświetla wyniki.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall & Larry Brown; można kopiować i modyfikować bez ograniczeń.
 */

public class NorthwindTest {
  public static void main(String[] args) {
    String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
    String url = "jdbc:odbc:Northwind";
    String username = ""; // nazwa użytkownika i hasło nie są
                          // wymagane w przypadku używania
    String password = ""; // MS Access na lokalnym komputerze.
    showEmployeeTable(driver, url, username, password);
  }

  /** Pobranie kolumn firstname (imie) oraz lastname (nazwisko) 
   *  z tabeli pracowników i wyświetlenie wyników.
   */
   
  public static void showEmployeeTable(String driver,
                                       String url,
                                       String username,
                                       String password) {
    try {
      // Załadowanie sterownika bazy danych jeżli jeszcze 
      // nie jest załadowany.
      Class.forName(driver);
      // Nawiązanie połączenia z bazą danych.
      Connection connection =
        DriverManager.getConnection(url, username, password);
      System.out.println("Pracownicy\n" + "===========");
      // Stworzenie obiektu polecenia i wykonanie zapytania.
      Statement statement = connection.createStatement();
      String query =
        "SELECT firstname, lastname FROM employees";
      // Przesłanie zapytania do bazy danych i zapisanie wyników.
      ResultSet resultSet = statement.executeQuery(query);
      // Wyświetlenie wyników.
      while(resultSet.next()) {
        System.out.print(resultSet.getString("firstname") + " ");
        System.out.println(resultSet.getString("lastname"));
      }
      connection.close();
    } catch(ClassNotFoundException cnfe) {
      System.err.println("Błąd podczas ładowania sterownika: " + cnfe);
    } catch(SQLException sqle) {
      System.err.println("Błąd podczas nawiązywania połączenia: " + sqle);
    }
  }
}   