package coreservlets;

import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Prosty serwlet, który nawiązuje połączenie z bazą danych
 *  i przedstawia wyniki zapytania w formie tabeli HTML.
 *	Klasa sterownika, URL, nazwa i hasło użytkownika oraz
 *  zapytanie są przekazywane jako parametry żądania.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall & Larry Brown; można kopiować i modyfikować bez ograniczeń.
 */

public class NorthwindServlet extends HttpServlet {
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    String docType =
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
      "Transitional//EN\"\n";
    String title = "Northwind Results";
    out.print(docType +
              "<HTML>\n" +
              "<HEAD><TITLE>" + title + "</TITLE>\n"+
              "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-2\">"+
              "</HEAD>\n" +
              "<BODY BGCOLOR=\"#FDF5E6\"><CENTER>\n" +
              "<H1>Wyniki pobrane z bazy danych</H1>\n");
    String driver = request.getParameter("driver");
    String url = request.getParameter("url");
    String username = request.getParameter("username");
    String password = request.getParameter("password");
    String query = request.getParameter("query");
    showTable(driver, url, username, password, query, out);
    out.println("</CENTER></BODY></HTML>");
  }

  public void showTable(String driver, String url,
                        String username, String password,
                        String query, PrintWriter out) {
    try {
      // Załadowanie sterownika bazy danych jeżli jeszcze 
      // nie jest załadowany.
      Class.forName(driver);
      // Nawiązanie połączenia z bazą danych.
      Connection connection =
        DriverManager.getConnection(url, username, password);
      // Pobranie informacji o bazie danych.
      DatabaseMetaData dbMetaData = connection.getMetaData();
      out.println("<UL>");
      String productName =
        dbMetaData.getDatabaseProductName();
      String productVersion =
        dbMetaData.getDatabaseProductVersion();
      out.println("  <LI><B>Baza danych:</B> " + productName +
                  "  <LI><B>Wersja:</B> " + productVersion +
                  "</UL>");
      Statement statement = connection.createStatement();
      // Przesłanie zapytania do bazy danych i zapisanie wyników.
      ResultSet resultSet = statement.executeQuery(query);
      // Wyświetlenie wyników.
      out.println("<TABLE BORDER=1>");
      ResultSetMetaData resultSetMetaData =
        resultSet.getMetaData();
      int columnCount = resultSetMetaData.getColumnCount();
      out.println("<TR>");
      // Indeksy kolumn zaczynają się od 1 (jak w SQL-u),
      // a nie od 0 (jak w Javie).
      for(int i=1; i <= columnCount; i++) {
        out.print("<TH>" + resultSetMetaData.getColumnName(i) + "</TH>");
      }
      out.println("</TR>");
      // Pobranie kolejno wszystkich wierszy ze zbioru wyników.
      while(resultSet.next()) {
        out.println("<TR>");
        // Pobranie wszystkich danych z wiersza, przy czym wartości
        // wszystkich komórek są pobierane jako dane typu String.
        for(int i=1; i <= columnCount; i++) {
          out.print("<TD>" + resultSet.getString(i) + "</TD>");
        }
        out.println("</TR>");
      }
      out.println("</TABLE>");
      connection.close();
    } catch(ClassNotFoundException cnfe) {
      System.err.println("Błąd podczas ładowania sterownika: " + cnfe);
    } catch(SQLException sqle) {
      System.err.println("Błąd podczas nawiązywania połączenia: " + sqle);
    } catch(Exception ex) {
      System.err.println("Błąd danych wejściowych: " + ex);
    }
  }
}            