package coreservlets;

import java.sql.*;
import coreservlets.beans.*;

/** Przykład prezentujący sposób wykonywania procedury 
 *  zachowanej o nazwie 'discount' na serwerze Oracle.
 *  Procedura powoduje obniżenie o 10 procent cen wszystkich 
 *  płyt z utworami Mozarta.
 *  <P>
 *  W celu utworzenia procedury zachowanej, w wierszu
 *  wywołania programu należy podać parametr "create".
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall & Larry Brown; można kopiować i modyfikować bez ograniczeń.
 */

public class CallableStatements {
  public static void main(String[] args) {
    if (args.length < 5) {
      printUsage();
      return;
    }
    String vendor = args[4];
    // W celu wczytania informacji o sterownikach z pliku 
    // XML należy użyć metody 
    // DriverUtilities2.loadDrivers().
    DriverUtilities.loadDrivers();
    if (!DriverUtilities.isValidVendor(vendor)) {
      printUsage();
      return;
    }
    String driver = DriverUtilities.getDriver(vendor);
    String host = args[0];
    String dbName = args[1];
    String url =
      DriverUtilities.makeURL(host, dbName, vendor);
    String username = args[2];
    String password = args[3];

    Connection connection =
      ConnectionInfoBean.getConnection(driver, url,
                                       username, password);
    if (connection == null) {
      return;
    }

    try {
      if ((args.length > 5) && (args[5].equals("create"))) {
        createStoredFunction(connection);
      }
      doCallableStatement(connection, "Mozart", 0.10F);
    } catch(SQLException sqle) {
      System.err.println("Nie udało się wywołać procedury: " + sqle);
    } finally {
      try {
        connection.close();
      } catch(SQLException sqle) {
        System.err.println("Nie udało się zamknąć połączenia: " + sqle);
      }
    }
  }

  private static void doCallableStatement(Connection connection,
                                          String composer,
                                          float discount)
      throws SQLException {
    CallableStatement statement = null;
    try {
      connection.prepareCall("{ ? = call discount( ?, ? ) }");
      statement.setString(2, composer);
      statement.setFloat(3, discount);
      statement.registerOutParameter(1, Types.INTEGER);
      statement.execute();
      int rows = statement.getInt(1);
      System.out.println("Liczba zmodyfikowanych wierszy: " + rows);
    } catch(SQLException sqle) {
      System.err.println("Nie udało się wywołać procedury: " + sqle);
    } finally {
      if (statement != null) {
        statement.close();
      }
    }
  }

  /** Utworzenie procedury zachowanej w języku Oracle PL/SQL.
   *  Procedura (a z technicznego punktu widzenia - funkcja - 
   *  gdyż zwraca wartość) obniża cenę płyt z utworami podanego
   *  kompozytora przechowywanymi w tabeli "music".
   */

  private static void createStoredFunction(
                        Connection connection)
      throws SQLException {
    String sql = "CREATE OR REPLACE FUNCTION discount " +
                 "  (composer_in IN VARCHAR2, " +
                 "   discount_in IN NUMBER) " +
                 "RETURN NUMBER " +
                 "IS " +
                 "  min_discount CONSTANT NUMBER:= 0.05; " +
                 "  max_discount CONSTANT NUMBER:= 0.50; " +
                 "BEGIN " +
                 "  IF discount_in BETWEEN min_discount " +
                 "                 AND max_discount THEN " +
                 "    UPDATE music " +
                 "    SET price = price * (1.0 - discount_in) "+
                 "    WHERE composer = composer_in; " +
                 "    RETURN(SQL%ROWCOUNT); " +
                 "  ELSE " +
                 "    RETURN(-1); " +
                 "  END IF; " +
                 "END discount;";
    Statement statement = null;
    try {
      statement = connection.createStatement();
      statement.executeUpdate(sql);
    } catch(SQLException sqle) {
      System.err.println("Nie udało się utworzyć funkcji: " + sqle);
    } finally {
      if (statement != null) {
        statement.close();
      }
    }
  }

  private static void printUsage() {
    System.out.println("Sposób użycia: CallableStatement komputer " +
                       "nazwaBazy użytkownik hasło " +
                       "typ [create].");
  }
}                       