package coreservlets;

/** Prosty komponent stosowany do przedstawienia
 *  rnych postaci znacznika jsp:setProperty.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class SaleEntry {
  private String itemID = "nieznany";
  private double discountCode = 1.0;
  private int numItems = 0;

  public String getItemID() {
    return(itemID);
  }

  public void setItemID(String itemID) {
    if (itemID != null) {
      this.itemID = itemID;
    } else {
      this.itemID = "nieznany";
    }
  }

  public double getDiscountCode() {
    return(discountCode);
  }

  public void setDiscountCode(double discountCode) {
    this.discountCode = discountCode;
  }

  public int getNumItems() {
    return(numItems);
  }

  public void setNumItems(int numItems) {
    this.numItems = numItems;
  }
  
  // W praktyce naleaoby zastpi ten kod prawdziwym
  // odwoaniem do bazy danych. Informacje na temat
  // wykorzystania baz danych w serwletach oraz stronach
  // JSP zostay zamieszczone w rozdziaach 17. i 18.
  
  public double getItemCost() {
    double cost;
    if (itemID.equals("a1234")) {
      cost = 12.99*getDiscountCode();
    } else {
      cost = -9999;
    }
    return(roundToPennies(cost));
  }

  private double roundToPennies(double cost) {
    return(Math.floor(cost*100)/100.0);
  }

  public double getTotalCost() {
    return(getItemCost() * getNumItems());
  }
}
