package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*; 

/** Prosty przykład śledzenia sesji przechowujący informacje
 *  o liczbie odwiedzin użytkownika na stronie. Oprócz tego
 *  prezentowane są także inne informacje o sesji.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class ShowSession extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    HttpSession session = request.getSession();
    String heading;
    Integer accessCount =
      (Integer)session.getAttribute("accessCount");
    if (accessCount == null) {
      accessCount = new Integer(0);
      heading = "Witamy, Nowy gościu";
    } else {
      heading = "Witamy ponownie";
      accessCount = new Integer(accessCount.intValue() + 1);
    }
    // Integer jest niemodyfikowalną strukturą danych.
    // A zatem nie można zmienić wartości istniejącego 
    // obiektu tego typu. Zamiast tego należy utworzyć
    // nowy obiekt i ponownie wywołać metodę setAttribute.
    session.setAttribute("accessCount", accessCount);
    PrintWriter out = response.getWriter();
    String title = "Przykład śledzenia sesji";
    String docType =
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
      "Transitional//EN\">\n";
    out.println(docType +
                "<HTML>\n" +
                "<HEAD><TITLE>" + title + "</TITLE></HEAD>\n" +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<CENTER>\n" +
                "<H1>" + heading + "</H1>\n" +
                "<H2>Informacje o sesji:</H2>\n" +
                "<TABLE BORDER=1>\n" +
                "<TR BGCOLOR=\"#FFAD00\">\n" +
                "  <TH>Typ informacji</TH><TH>Wartość</TH>\n" +
                "</TR><TR>\n" +
                "  <TD>Identyfikator</TD>\n" +
                "  <TD>" + session.getId() + "</TD>\n" +
                "</TR><TR>\n" +
                "  <TD>Czas utworzenia</TD>\n" +
                "  <TD>" +
                new Date(session.getCreationTime()) + "</TD>\n" +
                "</TR><TR>\n" +
                "  <TD>Czas ostatniego dostępu</TD>\n" +
                "  <TD>" +
                new Date(session.getLastAccessedTime()) + "</TD>\n" +
                "</TR><TR>\n" +
                "  <TD>Liczba odwiedzin</TD>\n" +
                "  <TD>" + accessCount + "</TD>\n" +
                "</TR></TABLE>\n" +
                "</CENTER></BODY></HTML>");
  }
}
