package coreservlets;

/** Opisuje element katalogu dla internetowego sklepu.
 *  identyfikator (itemID) w niepowtarzalny sposób identyfikuje każdy
 *  element, krótki opis (shortDescription) zawiera  
 *  krótkie informacje o produkcie (takie jak nazwisko 
 *  autora i tytuł książki), a długi opis (longDescription) 
 *  to kilka zdań dokładniej opisujących dany produkt; w końcu
 *  cena (cost) jest jednostkową ceną produktu.
 *  Zarówno krótki, jak i długi opis może zawierać kod HTML.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class CatalogItem {
  private String itemID;
  private String shortDescription;
  private String longDescription;
  private double cost;

  public CatalogItem(String itemID, String shortDescription,
                     String longDescription, double cost) {
    setItemID(itemID);
    setShortDescription(shortDescription);
    setLongDescription(longDescription);
    setCost(cost);
  }
    
  public String getItemID() {
    return(itemID);
  }

  protected void setItemID(String itemID) {
    this.itemID = itemID;
  }

  public String getShortDescription() {
    return(shortDescription);
  }

  protected void setShortDescription(String shortDescription) {
    this.shortDescription = shortDescription;
  }

  public String getLongDescription() {
    return(longDescription);
  }

  protected void setLongDescription(String longDescription) {
    this.longDescription = longDescription;
  }

  public double getCost() {
    return(cost);
  }

  protected void setCost(double cost) {
    this.cost = cost;
  }
}
