package coreservlets;

import javax.servlet.http.*;

/** Dwie statyczne metody używane podczas obsługi cookies.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class CookieUtilities {
  
  /** Mając dane: obiekt żądania, nazwę oraz wartość 
   *  domyślną, metoda próbuje pobrać wartość cookie o podanej
   *  nazwie. Jeśli takie cookie nie zostanie odnalezione,
   *  to metoda zwraca podaną wartość domyślną.
   */
  
  public static String getCookieValue
                           (HttpServletRequest request,
                            String cookieName,
                            String defaultValue) {
    Cookie[] cookies = request.getCookies();
    if (cookies != null) {
      for(int i=0; i<cookies.length; i++) {
        Cookie cookie = cookies[i];
        if (cookieName.equals(cookie.getName())) {
          return(cookie.getValue());
        }
      }
    }
    return(defaultValue);
  }

  /** Na podstawie obiektu żądania oraz nazwy, metoda ta
   *  próbuje odszukać i zwrócić obiekt cookie o podanej 
   *  nazwie. Jeśli cookie nie zostanie odnalezione, metoda
   *  zwraca wartość null.
   */
  
  public static Cookie getCookie(HttpServletRequest request,
                                 String cookieName) {
    Cookie[] cookies = request.getCookies();
    if (cookies != null) {
      for(int i=0; i<cookies.length; i++) {
        Cookie cookie = cookies[i];
        if (cookieName.equals(cookie.getName())) {
          return(cookie);
        }
      }
    }
    return(null);
  }
}
