package coreservlets;

/** Prosta klasa, która implementuje metody konstrukcji
 *  łańcucha zapytania dla różnych wyszukiwarek.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class SearchSpec {
  private String name, baseURL;

  public SearchSpec(String name,
                    String baseURL) {
    this.name = name;
    this.baseURL = baseURL;
  }

  /** Metoda tworzy URL do strony z wynikami poprzez 
   *  połączenie adresu bazowego (http://...?zmienna=") 
   *  z łańcuchem zapytania zakodowanym w formacie URL 
   *  (jsp+training).
   */
  
  public String makeURL(String searchString) {
    return(baseURL + searchString);
  }

  public String getName() {
    return(name);
  }
}
