package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Serwlet, który pobiera zapytanie
 *  oraz nazwę serwisu wyszukującego, a następnie 
 *  konstruuje zapytanie i przesyła je do wybranego serwisu.
 *  Przykład ilustruje wykorzystanie kodów statusu. 
 *  Serwlet przesyła kod 302 (generowany za pomocą metody
 *  sendRedirect) jeśli wybrana nazwa serwisu jest znana,
 *  oraz kod statusu 404 (za pomocą metody sendError) w
 *  przeciwnym przypadku. 
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class SearchEngines extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    String searchString = request.getParameter("searchString");
    if ((searchString == null) ||
        (searchString.length() == 0)) {
      reportProblem(response, "Brak zapytania.");
      return;
    }
    // Klasa URLEncoder zamienia odstępy na znaki "+", a 
    // pozostałe znaki, które nie są znakami alfanumerycznymi
    // na wyrażenia o postaci "%XY"; gdzie XY jest wartością danego
    // znaku w kodzie ASCII (lub ISO Latin-1) zapisaną w formie
    // liczby szesnastkowej. Przeglądarki zawsze automatycznie 
    // kodują wartości podawane w formularzach w ten  
    // sposób, a zatem metoda getParameter dekoduje je 
    // automatycznie. My jednak przekazujemy te dane do innego
    // serwera, a zatem musimy je ponownie zakodować, aby 
    // uniknąć pojawienia się znaków, które nie mogą występować
    // w adresach URL. Należy także zwrócić uwagę, iż w JDK 1.4 
    // pojawiła się dwuargumentowa wersja metody URLEncoder.encode,
    // a stosowanie wersji jednoargumentowej nie jest zalecane.
    // Jednak, ponieważ specyfikacja serwletów w wersji 2.3 wymaga
    // stosowania Java 2 Platform (JDK 1.2 i nowszych), zatem
    // dla zapewnienia zgodności będziemy używali
    // jednoargumentowej wersji tej metody.
    
    //searchString = URLEncoder.encode(searchString);
    
    String searchEngineName =
      request.getParameter("searchEngine");
    if ((searchEngineName == null) ||
        (searchEngineName.length() == 0)) {
      reportProblem(response, "Nie określono nazwy wyszukiwarki");
      return;
    }
    String searchURL =
      SearchUtilities.makeURL(searchEngineName, searchString);
    if (searchURL != null) {
      response.sendRedirect(searchURL);
    } else {
      reportProblem(response, "Nieznana wyszukiwarka");
    } 
  }

  private void reportProblem(HttpServletResponse response,
                             String message)
      throws IOException {
    response.sendError(HttpServletResponse.SC_NOT_FOUND, message);
  }
}
