package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Serwlet generujący <B>długą</B> stronę wynikową. Używany
 *  do sprawdzania wyników jakie daje kompresja przesyłanych
 *  stron.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class LongServlet extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    
    // Zmiana definicji strumienia "out" w zależności 
    //od tego czy kompresja gzip jest obsługiwana czy nie
    PrintWriter out;
    if (GzipUtilities.isGzipSupported(request) &&
        !GzipUtilities.isGzipDisabled(request)) {
      out = GzipUtilities.getGzipWriter(response);
      response.setHeader("Content-Encoding", "gzip");
    } else {
      out = response.getWriter();
    }

    // Po odpowiednim określeniu strumienia "out", dalszy 
    // kod strony nie zależy już od typu używanego 
    // obiektu pisarza.
    String docType =
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
      "Transitional//EN\">\n";
    String title = "Długa strona";
    out.println
      (docType +
       "<HTML>\n" +
       "<HEAD><TITLE>" + title + "</TITLE></HEAD>\n" +
       "<BODY BGCOLOR=\"#FDF5E6\">\n" +
       "<H1 ALIGN=\"CENTER\">" + title + "</H1>\n");
    String line = "Blah, blah, blah, blah, blah. " +
                  "Yadda, yadda, yadda, yadda.";
    for(int i=0; i<10000; i++) {
      out.println(line);
    }
    out.println("</BODY></HTML>");
    out.close(); // konieczne w przypadku stosowania kompresji gzip; 
                 // w innych przypadkach wywołanie to jest opcjonalne.
  }
}
