package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Przykład zastosowania inicjalizacji serwletu oraz
 *  metody getLastModified.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class LotteryNumbers extends HttpServlet {
  private long modTime;
  private int[] numbers = new int[10];

  /** Metoda init jest wywoływana tylko kiedy serwlet
   *  jest wczytywany, przed obsłużeniem pierwszego
   *  żądania.
   */
  
  public void init() throws ServletException {
    // Zaokrąglamy do najbliższej sekundy (czyli 1000 millisekund)
    modTime = System.currentTimeMillis()/1000*1000;
    for(int i=0; i<numbers.length; i++) {
      numbers[i] = randomNum();
    }
  }

  /** Zwraca listę liczb wygenerowanych w metodzie init. */
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    String title = "Szczęśliwe numery";
    String docType =
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
      "Transitional//EN\">\n";
    out.println(docType + 
                "<HTML>\n" +
                "<HEAD><TITLE>" + title + "</TITLE></HEAD>\n" +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=CENTER>" + title + "</H1>\n" +
                "<B>Bazując na wnikliwych badaniach" +
                "kosmicznie bezsensownych trendów, psychicznych bzdur " +
                "i bardzo mądrej naukowej paplaninie , " +
                "wybraliśmy " + numbers.length +
                " Twoich szczęśliwych numerków.</B>" +
                "<OL>");
    for(int i=0; i<numbers.length; i++) {
      out.println("  <LI>" + numbers[i]);
    }
    out.println("</OL>" +
                "</BODY></HTML>");
  }

  /** Standardowa metoda service porównuje tę datę
   *  z datą określoną w nagłówku żądania If-Modified-Since
   *  Jeśli data zwrócona przez metodę getLastModified jest
   *  późniejsza, lub jeśli nie ma nagłówka If-Modified-Since
   *  to metoda doGet jest wywoływana w zwykły sposób.
   *  Jeśli jednak data zwrócona przez metodę getLastModified
   *  jest taka sama lub wcześniejsza, metoda service wysyła
   *  do klienta odpowiedź 304 (Not Modified) - (nie zmieniony)
   *  i <B>nie</B> wywołuje metody doGet. W takiej sytuacji 
   *  przeglądarka powinna użyć strony przechowywanej w pamięci
   *  podręcznej.
   */
  
  public long getLastModified(HttpServletRequest request) {
    return(modTime);
  }

  // Losowe liczby całkowite z zakresu od 0 to 99.
  
  private int randomNum() {
    return((int)(Math.random() * 100));
  }
}