package coreservlets.beans;

import coreservlets.*;

/** Prosty komponent reprezentujący informacje konieczne 
 *  do wyliczenia kosztów ubezpieczenia pracownika.
 *  Posiada właściwości typów int, String oraz boolean.
 *  Klasa używana do przedstawienia możliwości automatycznego
 *  określania wartości właściwości komponentu na podstawie
 *  parametrów żądania.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class InsuranceInfo {
  private String name = "Nie podno personaliów";
  private String employeeID = "Nie podano identyfikatora";
  private int numChildren = 0;
  private boolean isMarried = false;

  public String getName() {
    return(name);
  }

  /** Wartść parametru jest filtrowana na wypadek gdyby 
   *  użytkownik wpisał w polu jakieś znaki specjalne HTML.
   */
  
  public void setName(String name) {
    this.name = ServletUtilities.filter(name);
  }

  public String getEmployeeID() {
    return(employeeID);
  }

  /** Wartść parametru jest filtrowana na wypadek gdyby 
   *  użytkownik wpisał w polu jakieś znaki specjalne HTML.
   */
  
  public void setEmployeeID(String employeeID) {
    this.employeeID = ServletUtilities.filter(employeeID);
  }

  public int getNumChildren() {
    return(numChildren);
  }

  public void setNumChildren(int numChildren) {
    this.numChildren = numChildren;
  }

  /** Konwencja określania nazw metod komponentów: w przypadku 
   *  właściwości typu boolean metody służące do podawania oraz 
   *  odczytywania jej wartości powinny nosić nazwy: "isXxx" 
   *  oraz "getXxx".
   */
  
  public boolean isMarried() {
    return(isMarried);
  }

  public void setMarried(boolean isMarried) {
    this.isMarried = isMarried;
  }
}
