import java.awt.*;
import java.awt.event.*;

/** Okno klasy Frame umożliwiające zakończenie aplikacji. Używane
 *  jako punkt startowy dla większości aplikacji opartych o AWT.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class CloseableFrame extends Frame {
  public CloseableFrame(String title) {
    super(title);
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
  }

  /** Najpierw wywołujemy super.processWindowEvent aby obsłużyć
   *  inne typy zdarzeń niż WINDOWS_CLOSING.
   */
  
  public void processWindowEvent(WindowEvent event) {
    super.processWindowEvent(event); // Handle listeners
    if (event.getID() == WindowEvent.WINDOW_CLOSING)
      System.exit(0);
  }
}
